/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class RenderHelper {
    private static final Cache<Integer, TextureAtlasSprite> SPRITE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private RenderHelper() {
    }

    public static TextureAtlasSprite getSprite(ResourceLocation blockName, @Nullable Direction direction, Random rand) {
        int hash = blockName.hashCode();
        TextureAtlasSprite sprite = (TextureAtlasSprite)SPRITE_CACHE.getIfPresent((Object)(hash = hash * 31 + (direction == null ? 0 : direction.hashCode())));
        if (sprite == null) {
            sprite = RenderHelper.parseSprite(blockName, direction, rand);
            SPRITE_CACHE.put((Object)hash, (Object)sprite);
        }
        return sprite;
    }

    private static TextureAtlasSprite parseSprite(ResourceLocation blockName, @Nullable Direction direction, Random rand) {
        BlockState blockState = RenderHelper.getDefaultBlockState(blockName);
        TextureAtlasSprite sprite = RenderHelper.parseSpriteFromModel(blockState, direction, rand);
        if (sprite == null) {
            sprite = Minecraft.m_91087_().m_91304_().m_119409_().getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        }
        return sprite;
    }

    @Nullable
    private static TextureAtlasSprite parseSpriteFromModel(BlockState blockState, @Nullable Direction direction, Random rand) {
        TextureAtlasSprite sprite = null;
        BakedModel blockModel = Minecraft.m_91087_().m_91289_().m_110910_(blockState);
        try {
            List culledQuads = blockModel.getQuads(blockState, direction, rand, (IModelData)EmptyModelData.INSTANCE);
            if (!culledQuads.isEmpty()) {
                return ((BakedQuad)culledQuads.get(0)).m_173410_();
            }
            for (BakedQuad bakedQuad : blockModel.m_6840_(blockState, null, rand)) {
                if (sprite == null) {
                    sprite = bakedQuad.m_173410_();
                }
                if (bakedQuad.m_111306_() != direction) continue;
                return bakedQuad.m_173410_();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sprite == null) {
            try {
                sprite = blockModel.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sprite;
    }

    private static BlockState getDefaultBlockState(ResourceLocation blockName) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
        return block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_();
    }

    static void renderQuad(VertexConsumer consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha) {
        RenderHelper.renderQuad(consumer, pose, normal, packedOverlay, packedLight, alpha, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    static void renderQuad(VertexConsumer consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha, float minU, float minV, float maxU, float maxV) {
        boolean minX = false;
        int minY = 0;
        int maxY = 1;
        boolean maxX = true;
        RenderHelper.addVertex(pose, normal, consumer, maxY, (float)minX, packedOverlay, packedLight, maxU, minV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, minY, (float)minX, packedOverlay, packedLight, maxU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, minY, (float)maxX, packedOverlay, packedLight, minU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, maxY, (float)maxX, packedOverlay, packedLight, minU, minV, alpha);
    }

    private static void addVertex(Matrix4f pose, Vector3f normal, VertexConsumer pConsumer, int pY, float pX, int packedOverlay, int packedLight, float u, float v, float alpha) {
        Vector4f pos = new Vector4f(pX, (float)pY, 0.0f, 1.0f);
        pos.m_123607_(pose);
        pConsumer.m_5954_(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), 1.0f, 1.0f, 1.0f, alpha, u, v, packedOverlay, packedLight, normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
    }
}

