/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.CompositeElementsModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class BarrelBakedModelBase
implements IDynamicBakedModel {
    private static final Map<ItemTransforms.TransformType, Transformation> TRANSFORMS;
    private static final ItemTransforms ITEM_TRANSFORMS;
    private static final QuadTransformer MOVE_TO_CORNER;
    public static final Map<Direction, QuadTransformer> DIRECTION_ROTATES;
    private static final LoadingCache<Direction, Cache<Integer, QuadTransformer>> DIRECTION_MOVES_3D_ITEMS;
    private static final QuadTransformer SCALE_BIG_2D_ITEM;
    private static final QuadTransformer SCALE_SMALL_3D_ITEM;
    private static final QuadTransformer SCALE_SMALL_2D_ITEM;
    private static final Cache<Integer, QuadTransformer> DIRECTION_MOVE_BACK_TO_SIDE;
    private static final ModelProperty<String> WOOD_NAME;
    private static final ModelProperty<Boolean> IS_PACKED;
    private static final ModelProperty<Boolean> SHOWS_LOCK;
    private static final ModelProperty<Boolean> SHOWS_TIER;
    private static final ModelProperty<Boolean> HAS_MAIN_COLOR;
    private static final ModelProperty<Boolean> HAS_ACCENT_COLOR;
    private static final ModelProperty<List<RenderInfo.DisplayItem>> DISPLAY_ITEMS;
    private static final ModelProperty<List<Integer>> INACCESSIBLE_SLOTS;
    private static final Cache<Integer, List<BakedQuad>> BAKED_QUADS_CACHE;
    private static final Map<Integer, QuadTransformer> DISPLAY_ROTATIONS;
    private static final ModelProperty<Map<BarrelMaterial, ResourceLocation>> MATERIALS;
    private static final List<BarrelMaterial> PARTICLE_ICON_MATERIAL_PRIORITY;
    protected final Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts;
    private final ItemOverrides barrelItemOverrides;
    private Item barrelItem = Items.f_41852_;
    @Nullable
    private String barrelWoodName = null;
    private boolean barrelHasMainColor = false;
    private boolean barrelHasAccentColor = false;
    private boolean barrelIsPacked = false;
    private boolean barrelShowsTier = true;
    private Map<BarrelMaterial, ResourceLocation> barrelMaterials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
    private boolean flatTop = false;
    private final Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData;
    private final Map<String, Map<BarrelModelPart, BakedModel>> woodPartitionedModelParts;
    private final Cache<Integer, BakedModel> dynamicBakedModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final ModelBakery modelBakery;

    private static ItemTransforms createItemTransforms() {
        return new ItemTransforms(BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND)), BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND)), BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND)), BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND)), BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.HEAD)), BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GUI)), BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GROUND)), BarrelBakedModelBase.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIXED)));
    }

    private static ItemTransform fromTransformation(Transformation transformation) {
        return new ItemTransform(transformation.m_121105_().m_175217_(), transformation.m_175940_(), transformation.m_175941_());
    }

    public static void invalidateCache() {
        DIRECTION_MOVES_3D_ITEMS.invalidateAll();
        DIRECTION_MOVE_BACK_TO_SIDE.invalidateAll();
        BAKED_QUADS_CACHE.invalidateAll();
    }

    protected BarrelBakedModelBase(ModelBakery modelBakery, Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts, @Nullable BakedModel flatTopModel, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData, Map<String, Map<BarrelModelPart, BakedModel>> woodPartitionedModelParts) {
        this.modelBakery = modelBakery;
        this.woodModelParts = woodModelParts;
        this.barrelItemOverrides = new BarrelItemOverrides(this, flatTopModel);
        this.woodDynamicBakingData = woodDynamicBakingData;
        this.woodPartitionedModelParts = woodPartitionedModelParts;
    }

    private static QuadTransformer getDirectionRotationTransform(Direction dir) {
        return new QuadTransformer(new Transformation(null, DisplayItemRenderer.getNorthBasedRotation(dir), null, null));
    }

    private QuadTransformer getDirectionMoveBackToSide(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = this.calculateMoveBackToSideHash(state, dir, distFromCenter, displayItemIndex, displayItemCount);
        QuadTransformer transform = (QuadTransformer)DIRECTION_MOVE_BACK_TO_SIDE.getIfPresent((Object)hash);
        if (transform == null) {
            Vec3i normal = dir.m_122436_();
            Vector3f offset = new Vector3f(distFromCenter, distFromCenter, distFromCenter);
            offset.m_122263_((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount);
            frontOffset.m_122272_(-0.5f, -0.5f, -0.5f);
            this.rotateDisplayItemFrontOffset(state, dir, frontOffset);
            frontOffset.m_122272_(0.5f, 0.5f, 0.5f);
            offset.m_122253_(frontOffset);
            transform = new QuadTransformer(new Transformation(offset, null, null, null));
            DIRECTION_MOVE_BACK_TO_SIDE.put((Object)hash, (Object)transform);
        }
        return transform;
    }

    protected void rotateDisplayItemFrontOffset(BlockState state, Direction dir, Vector3f frontOffset) {
        frontOffset.m_122251_(DisplayItemRenderer.getNorthBasedRotation(dir));
    }

    protected int calculateMoveBackToSideHash(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = Float.hashCode(distFromCenter);
        hash = 31 * hash + displayItemIndex;
        hash = 31 * hash + displayItemCount;
        return hash;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        boolean showsTier;
        Map<BarrelMaterial, ResourceLocation> materials;
        boolean isPacked;
        boolean hasAccentColor;
        boolean hasMainColor;
        int hash = this.createHash(state, side, extraData);
        List quads = (List)BAKED_QUADS_CACHE.getIfPresent((Object)hash);
        if (quads != null) {
            return quads;
        }
        String woodName = null;
        if (state != null) {
            hasMainColor = Boolean.TRUE.equals(extraData.getData(HAS_MAIN_COLOR));
            hasAccentColor = Boolean.TRUE.equals(extraData.getData(HAS_ACCENT_COLOR));
            if (extraData.hasProperty(WOOD_NAME)) {
                woodName = (String)extraData.getData(WOOD_NAME);
            }
            isPacked = this.isPacked(extraData);
            materials = this.getMaterials(extraData);
            showsTier = this.showsTier(extraData);
        } else {
            woodName = this.barrelWoodName;
            hasMainColor = this.barrelHasMainColor;
            hasAccentColor = this.barrelHasAccentColor;
            isPacked = this.barrelIsPacked;
            materials = this.barrelMaterials;
            showsTier = this.barrelShowsTier;
        }
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        boolean isBakedDynamically = !materials.isEmpty() && this.woodDynamicBakingData.containsKey(woodName);
        Set materialModelParts = materials.keySet().stream().map(BarrelMaterial::getMaterialModelPart).collect(Collectors.toSet());
        boolean rendersUsingSplitModel = materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM);
        Map<BarrelModelPart, BakedModel> modelParts = this.getWoodModelParts(woodName, isBakedDynamically && rendersUsingSplitModel);
        if (modelParts.isEmpty()) {
            return Collections.emptyList();
        }
        if (!(hasMainColor && hasAccentColor || isBakedDynamically)) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getBasePart(state));
        }
        this.addTintableModelQuads(state, side, rand, ret, hasMainColor, hasAccentColor, modelParts);
        if (isBakedDynamically) {
            this.bakeAndAddDynamicQuads(BarrelBakedModelBase.getSpriteSide(state, side), rand, woodName, materials, rendersUsingSplitModel, !hasMainColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE), !hasAccentColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM)).forEach(bakedModel -> ret.addAll(bakedModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE)));
        }
        if (showsTier) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.TIER);
        }
        if (isPacked) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.PACKED);
        } else {
            if (this.showsLocked(extraData)) {
                this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.LOCKED);
            }
            this.addDisplayItemQuads(state, side, rand, ret, extraData);
        }
        BAKED_QUADS_CACHE.put((Object)hash, ret);
        return ret;
    }

    public List<BakedQuad> getTierQuads(BlockState state, Random rand, String woodName) {
        return this.getPartQuads(state, rand, woodName, BarrelModelPart.TIER);
    }

    public List<BakedQuad> getLockQuads(BlockState state, Random rand, String woodName) {
        return this.getPartQuads(state, rand, woodName, BarrelModelPart.LOCKED);
    }

    private List<BakedQuad> getPartQuads(BlockState state, Random rand, String woodName, BarrelModelPart part) {
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        Map<BarrelModelPart, BakedModel> modelParts = this.getWoodModelParts(woodName, false);
        for (Direction dir : Direction.values()) {
            this.addPartQuads(state, dir, rand, ret, modelParts, part);
        }
        return ret;
    }

    private static Direction getSpriteSide(@Nullable BlockState state, @Nullable Direction side) {
        Direction sideBeforeRotation;
        Block block;
        if (side == null) {
            return Direction.NORTH;
        }
        if (state != null && (block = state.m_60734_()) instanceof BarrelBlock) {
            BarrelBlock barrelBlock = (BarrelBlock)block;
            sideBeforeRotation = BlockSide.fromDirection(side, barrelBlock.getHorizontalDirection(state), barrelBlock.getVerticalFacing(state)).toDirection(Direction.NORTH, VerticalFacing.NO);
        } else {
            sideBeforeRotation = BlockSide.fromDirection(side, Direction.NORTH, VerticalFacing.UP).toDirection(Direction.NORTH, VerticalFacing.NO);
        }
        return sideBeforeRotation;
    }

    private List<BakedModel> bakeAndAddDynamicQuads(@Nullable Direction spriteSide, Random rand, @Nullable String woodName, Map<BarrelMaterial, ResourceLocation> barrelMaterials, boolean rendersUsingSplitModel, boolean renderCore, boolean renderTrim) {
        Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData = this.woodDynamicBakingData.get(woodName);
        HashMap<String, Either<Material, String>> materials = new HashMap<String, Either<Material, String>>();
        for (Map.Entry<BarrelMaterial, ResourceLocation> entry : barrelMaterials.entrySet()) {
            BarrelMaterial barrelMaterial = entry.getKey();
            ResourceLocation blockName = entry.getValue();
            TextureAtlasSprite sprite = RenderHelper.getSprite(blockName, spriteSide, rand);
            Either material = Either.left((Object)new Material(InventoryMenu.f_39692_, sprite.m_118413_()));
            for (BarrelMaterial childMaterial : barrelMaterial.getChildren()) {
                materials.put(childMaterial.m_7912_(), (Either<Material, String>)material);
            }
        }
        ArrayList<BakedModel> models = new ArrayList<BakedModel>();
        if (rendersUsingSplitModel) {
            if (renderCore) {
                models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.CORE));
            }
            if (renderTrim) {
                models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.TRIM));
            }
        } else {
            models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.WHOLE));
        }
        return models;
    }

    private BakedModel getDynamicModel(@Nullable String woodName, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData, Map<String, Either<Material, String>> materials, DynamicBarrelBakingData.DynamicPart dynamicPart) {
        int hash = Objects.hash(woodName, materials, dynamicPart.name());
        BakedModel bakedModel = (BakedModel)this.dynamicBakedModelCache.getIfPresent((Object)hash);
        if (bakedModel == null) {
            bakedModel = this.compileAndBakeModel(materials, bakingData.get((Object)dynamicPart));
            this.dynamicBakedModelCache.put((Object)hash, (Object)bakedModel);
        }
        return bakedModel;
    }

    private BlockState getDefaultBlockState(ResourceLocation blockName) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
        return block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_();
    }

    private Map<BarrelMaterial, ResourceLocation> getMaterials(IModelData extraData) {
        return extraData.hasProperty(MATERIALS) ? Objects.requireNonNull((Map)extraData.getData(MATERIALS)) : Collections.emptyMap();
    }

    private BakedModel compileAndBakeModel(Map<String, Either<Material, String>> materials, DynamicBarrelBakingData bakingData) {
        bakingData.modelPartDefinition().textures().forEach((textureName, texture) -> {
            if (!materials.containsKey(textureName)) {
                materials.put((String)textureName, (Either<Material, String>)Either.left((Object)texture));
            }
        });
        BarrelDynamicModelBase.BarrelModelPartDefinition baseModelPartDefinition = bakingData.modelPartDefinition();
        return baseModelPartDefinition.modelLocation().map(modelLocation -> {
            CompositeElementsModel baseModel = new CompositeElementsModel((ResourceLocation)modelLocation, materials);
            baseModel.m_5500_(arg_0 -> ((ModelBakery)this.modelBakery).m_119341_(arg_0), new HashSet());
            return baseModel.m_111449_(this.modelBakery, baseModel, arg_0 -> ((AtlasSet)this.modelBakery.getSpriteMap()).m_117971_(arg_0), bakingData.modelState(), bakingData.modelLocation(), false);
        }).orElse(Minecraft.m_91087_().m_91304_().m_119409_());
    }

    protected abstract BarrelModelPart getBasePart(@Nullable BlockState var1);

    private boolean isPacked(IModelData extraData) {
        return extraData.hasProperty(IS_PACKED) && Boolean.TRUE.equals(extraData.getData(IS_PACKED));
    }

    private boolean showsLocked(IModelData extraData) {
        return extraData.hasProperty(SHOWS_LOCK) && Boolean.TRUE.equals(extraData.getData(SHOWS_LOCK));
    }

    private boolean showsTier(IModelData extraData) {
        return extraData.hasProperty(SHOWS_TIER) && Boolean.TRUE.equals(extraData.getData(SHOWS_TIER));
    }

    private int createHash(@Nullable BlockState state, @Nullable Direction side, IModelData data) {
        int hash = state != null ? this.getInWorldBlockHash(state, data) : this.getItemBlockHash();
        hash = hash * 31 + (side == null ? 0 : side.m_122411_() + 1);
        hash = this.getDisplayItemsHash(data, hash);
        return hash;
    }

    private int getItemBlockHash() {
        int hash = this.barrelItem.hashCode();
        hash = hash * 31 + (this.barrelWoodName != null ? this.barrelWoodName.hashCode() + 1 : 0);
        hash = hash * 31 + (this.barrelHasMainColor ? 1 : 0);
        hash = hash * 31 + (this.barrelHasAccentColor ? 1 : 0);
        hash = hash * 31 + (this.barrelIsPacked ? 1 : 0);
        hash = hash * 31 + (this.barrelShowsTier ? 1 : 0);
        hash = hash * 31 + (this.flatTop ? 1 : 0);
        hash = hash * 31 + this.barrelMaterials.hashCode();
        return hash;
    }

    protected int getInWorldBlockHash(BlockState state, IModelData data) {
        int hash = state.m_60734_().hashCode();
        hash = hash * 31 + (data.hasProperty(WOOD_NAME) ? ((String)data.getData(WOOD_NAME)).hashCode() + 1 : 0);
        hash = hash * 31 + (data.hasProperty(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.getData(HAS_MAIN_COLOR)) ? 1 : 0);
        hash = hash * 31 + (data.hasProperty(HAS_ACCENT_COLOR) && Boolean.TRUE.equals(data.getData(HAS_ACCENT_COLOR)) ? 1 : 0);
        hash = hash * 31 + (this.isPacked(data) ? 1 : 0);
        hash = hash * 31 + (this.showsLocked(data) ? 1 : 0);
        hash = hash * 31 + (this.showsTier(data) ? 1 : 0);
        hash = hash * 31 + (Boolean.TRUE.equals(state.m_61143_((Property)BarrelBlock.FLAT_TOP)) ? 1 : 0);
        hash = hash * 31 + (data.hasProperty(MATERIALS) ? ((Map)data.getData(MATERIALS)).hashCode() : 0);
        return hash;
    }

    private int getDisplayItemsHash(IModelData data, int hash) {
        if (data.hasProperty(DISPLAY_ITEMS)) {
            List displayItems = (List)data.getData(DISPLAY_ITEMS);
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                hash = hash * 31 + this.getDisplayItemHash(displayItem);
            }
        }
        if (data.hasProperty(INACCESSIBLE_SLOTS)) {
            List inaccessibleSlots = (List)data.getData(INACCESSIBLE_SLOTS);
            for (Integer inaccessibleSlot : inaccessibleSlots) {
                hash = hash * 31 + inaccessibleSlot;
            }
        }
        return hash;
    }

    private int getDisplayItemHash(RenderInfo.DisplayItem displayItem) {
        int hash = displayItem.getRotation();
        hash = hash * 31 + ItemStackKey.getHashCode((ItemStack)displayItem.getItem());
        hash = hash * 31 + displayItem.getSlotIndex();
        return hash;
    }

    private void addDisplayItemQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, IModelData data) {
        Block block;
        if (state == null || side != null || !((block = state.m_60734_()) instanceof BarrelBlock)) {
            return;
        }
        BarrelBlock barrelBlock = (BarrelBlock)block;
        List displayItems = (List)data.getData(DISPLAY_ITEMS);
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        if (displayItems != null && !displayItems.isEmpty()) {
            int index = 0;
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                ItemStack item = displayItem.getItem();
                if (barrelBlock.hasFixedIndexDisplayItems()) {
                    index = displayItem.getSlotIndex();
                }
                if (item.m_41619_()) continue;
                BakedModel model = itemRenderer.m_174264_(item, null, (LivingEntity)minecraft.f_91074_, 0);
                if (!model.m_7521_()) {
                    int rotation = displayItem.getRotation();
                    for (Direction face : Direction.values()) {
                        this.addRenderedItemSide(state, rand, ret, item, model, rotation, face, index, barrelBlock.getDisplayItemsCount(displayItems));
                    }
                    this.addRenderedItemSide(state, rand, ret, item, model, rotation, null, index, barrelBlock.getDisplayItemsCount(displayItems));
                }
                ++index;
            }
        }
        this.addInaccessibleSlotsQuads(state, rand, ret, data, barrelBlock, displayItems, minecraft);
    }

    private void addInaccessibleSlotsQuads(BlockState state, Random rand, List<BakedQuad> ret, IModelData data, BarrelBlock barrelBlock, @Nullable List<RenderInfo.DisplayItem> displayItems, Minecraft minecraft) {
        List inaccessibleSlots = (List)data.getData(INACCESSIBLE_SLOTS);
        if (displayItems != null && inaccessibleSlots != null) {
            ItemStack inaccessibleSlotStack = new ItemStack((ItemLike)ModItems.INACCESSIBLE_SLOT.get());
            BakedModel model = minecraft.m_91291_().m_174264_(inaccessibleSlotStack, null, (LivingEntity)minecraft.f_91074_, 0);
            Iterator iterator = inaccessibleSlots.iterator();
            while (iterator.hasNext()) {
                int inaccessibleSlot = (Integer)iterator.next();
                if (model.m_7521_()) continue;
                for (Direction face : Direction.values()) {
                    this.addRenderedItemSide(state, rand, ret, inaccessibleSlotStack, model, 0, face, inaccessibleSlot, barrelBlock.getDisplayItemsCount(displayItems));
                }
                this.addRenderedItemSide(state, rand, ret, inaccessibleSlotStack, model, 0, null, inaccessibleSlot, barrelBlock.getDisplayItemsCount(displayItems));
            }
        }
    }

    private void addRenderedItemSide(BlockState state, Random rand, List<BakedQuad> ret, ItemStack displayItem, BakedModel model, int rotation, @Nullable Direction dir, int displayItemIndex, int displayItemCount) {
        Direction direction;
        Block block;
        List quads = model.m_6840_(null, dir, rand);
        quads = MOVE_TO_CORNER.processMany(quads);
        quads = new QuadTransformer(TransformationHelper.toTransformation((ItemTransform)model.m_7442_().m_111808_(ItemTransforms.TransformType.FIXED))).processMany(quads);
        if (!model.m_7539_()) {
            quads = displayItemCount == 1 ? SCALE_BIG_2D_ITEM.processMany(quads) : SCALE_SMALL_2D_ITEM.processMany(quads);
        } else if (displayItemCount > 1) {
            quads = SCALE_SMALL_3D_ITEM.processMany(quads);
        }
        if (rotation != 0) {
            quads = this.getDisplayRotation(rotation).processMany(quads);
        }
        if ((block = state.m_60734_()) instanceof BarrelBlock) {
            BarrelBlock barrelBlock = (BarrelBlock)block;
            direction = barrelBlock.getFacing(state);
        } else {
            direction = Direction.NORTH;
        }
        Direction facing = direction;
        quads = this.rotateDisplayItemQuads(quads, state);
        if (model.m_7539_()) {
            QuadTransformer transformer = this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, displayItemCount == 1 ? 1.0f : 0.5f);
            quads = transformer.processMany(quads);
            this.recalculateDirections(quads);
        } else {
            quads = this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, 1.0f).processMany(quads);
            this.recalculateDirections(quads);
        }
        this.updateTintIndexes(quads, displayItemIndex);
        ret.addAll(quads);
    }

    protected abstract List<BakedQuad> rotateDisplayItemQuads(List<BakedQuad> var1, BlockState var2);

    private void updateTintIndexes(List<BakedQuad> quads, int displayItemIndex) {
        int offset = (displayItemIndex + 1) * 10;
        quads.forEach(quad -> {
            if (quad.f_111293_ >= 0) {
                quad.f_111293_ += offset;
            }
        });
    }

    private void recalculateDirections(List<BakedQuad> quads) {
        quads.forEach(quad -> {
            quad.f_111294_ = FaceBakery.m_111612_((int[])quad.m_111303_());
        });
    }

    private QuadTransformer getDirectionMove(ItemStack displayItem, BakedModel model, BlockState state, Direction direction, int displayItemIndex, int displayItemCount, float itemScale) {
        boolean isFlatTop = (Boolean)state.m_61143_((Property)BarrelBlock.FLAT_TOP);
        int hash = this.calculateDirectionMoveHash(state, displayItem, displayItemIndex, displayItemCount, isFlatTop);
        Cache directionCache = (Cache)DIRECTION_MOVES_3D_ITEMS.getUnchecked((Object)direction);
        QuadTransformer transformer = (QuadTransformer)directionCache.getIfPresent((Object)hash);
        if (transformer == null) {
            double offset = DisplayItemRenderer.getDisplayItemOffset(displayItem, model, itemScale);
            if (!isFlatTop) {
                offset -= 0.0625;
            }
            transformer = this.getDirectionMoveBackToSide(state, direction, (float)(0.5 + offset), displayItemIndex, displayItemCount);
            directionCache.put((Object)hash, (Object)transformer);
        }
        return transformer;
    }

    protected int calculateDirectionMoveHash(BlockState state, ItemStack displayItem, int displayItemIndex, int displayItemCount, boolean isFlatTop) {
        int hashCode = ItemStackKey.getHashCode((ItemStack)displayItem);
        hashCode = hashCode * 31 + displayItemIndex;
        hashCode = hashCode * 31 + displayItemCount;
        hashCode = hashCode * 31 + (isFlatTop ? 1 : 0);
        return hashCode;
    }

    private QuadTransformer getDisplayRotation(int rotation) {
        return DISPLAY_ROTATIONS.computeIfAbsent(rotation, r -> new QuadTransformer(new Transformation(null, Vector3f.f_122227_.m_122240_((float)rotation), null, null)));
    }

    private void addTintableModelQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, boolean hasMainColor, boolean hasAccentColor, Map<BarrelModelPart, BakedModel> modelParts) {
        if (hasAccentColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.TINTABLE_ACCENT);
        }
        if (hasMainColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getMainPart(state));
        }
    }

    private BarrelModelPart getMainPart(@Nullable BlockState state) {
        return this.rendersOpen() && state != null && Boolean.TRUE.equals(state.m_61143_((Property)BarrelBlock.OPEN)) ? BarrelModelPart.TINTABLE_MAIN_OPEN : BarrelModelPart.TINTABLE_MAIN;
    }

    protected abstract boolean rendersOpen();

    private void addPartQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, Map<BarrelModelPart, BakedModel> modelParts, BarrelModelPart part) {
        if (modelParts.containsKey((Object)part)) {
            ret.addAll(modelParts.getOrDefault((Object)part, Minecraft.m_91087_().m_91304_().m_119409_()).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
        }
    }

    private Map<BarrelModelPart, BakedModel> getWoodModelParts(@Nullable String barrelWoodName, boolean requiresPartitionedModel) {
        if (requiresPartitionedModel && this.woodPartitionedModelParts.containsKey(barrelWoodName)) {
            return this.woodPartitionedModelParts.get(barrelWoodName);
        }
        if (this.woodModelParts.isEmpty()) {
            return Collections.emptyMap();
        }
        if (barrelWoodName == null || !this.woodModelParts.containsKey(barrelWoodName)) {
            return this.woodModelParts.values().iterator().next();
        }
        return this.woodModelParts.get(barrelWoodName);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getWoodModelParts(null, false).getOrDefault((Object)BarrelModelPart.BASE, Minecraft.m_91087_().m_91304_().m_119409_()).m_6160_();
    }

    public ItemTransforms m_7442_() {
        return ITEM_TRANSFORMS;
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        Map materials;
        if (data.hasProperty(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.getData(HAS_MAIN_COLOR))) {
            return this.getWoodModelParts(null, false).get((Object)BarrelModelPart.TINTABLE_MAIN).getParticleIcon(data);
        }
        if (data.hasProperty(MATERIALS) && (materials = (Map)data.getData(MATERIALS)) != null) {
            for (BarrelMaterial barrelMaterial : PARTICLE_ICON_MATERIAL_PRIORITY) {
                if (!materials.containsKey((Object)barrelMaterial)) continue;
                BlockState blockState = this.getDefaultBlockState((ResourceLocation)materials.get((Object)barrelMaterial));
                return Minecraft.m_91087_().m_91289_().m_110910_(blockState).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
            }
        }
        if (data.hasProperty(WOOD_NAME)) {
            String name = (String)data.getData(WOOD_NAME);
            if (!this.woodModelParts.containsKey(name)) {
                return this.m_6160_();
            }
            return this.getWoodModelParts(name, false).get((Object)BarrelModelPart.BASE).getParticleIcon(data);
        }
        return this.m_6160_();
    }

    @Nonnull
    public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
        return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BarrelBlockEntity.class).map(be -> {
            Map<BarrelMaterial, ResourceLocation> materials;
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            boolean hasMainColor = be.getStorageWrapper().hasMainColor();
            builder.withInitial(HAS_MAIN_COLOR, (Object)hasMainColor);
            boolean hasAccentColor = be.getStorageWrapper().hasAccentColor();
            builder.withInitial(HAS_ACCENT_COLOR, (Object)hasAccentColor);
            if (!be.hasFullyDynamicRenderer()) {
                builder.withInitial(DISPLAY_ITEMS, (Object)be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItems());
                builder.withInitial(INACCESSIBLE_SLOTS, (Object)be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getInaccessibleSlots());
            }
            builder.withInitial(IS_PACKED, (Object)be.isPacked());
            builder.withInitial(SHOWS_LOCK, (Object)(be.isLocked() && be.shouldShowLock() ? 1 : 0));
            builder.withInitial(SHOWS_TIER, (Object)be.shouldShowTier());
            Optional<WoodType> woodType = be.getWoodType();
            if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
                builder.withInitial(WOOD_NAME, (Object)woodType.orElse(WoodType.f_61833_).m_61846_());
            }
            if (!(materials = be.getMaterials()).isEmpty()) {
                builder.withInitial(MATERIALS, materials);
            }
            return builder.build();
        }).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    public ItemOverrides m_7343_() {
        return this.barrelItemOverrides;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack matrixStack) {
        if (cameraTransformType == ItemTransforms.TransformType.NONE) {
            return this;
        }
        Transformation tr = TRANSFORMS.get(cameraTransformType);
        if (!tr.isIdentity()) {
            tr.push(matrixStack);
        }
        return this;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.15625f, 0.0f), new Quaternion(75.0f, 45.0f, 0.0f, true), new Vector3f(0.375f, 0.375f, 0.375f), null));
        builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.15625f, 0.0f), new Quaternion(75.0f, 45.0f, 0.0f, true), new Vector3f(0.375f, 0.375f, 0.375f), null));
        builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 225.0f, 0.0f, true), new Vector3f(0.4f, 0.4f, 0.4f), null));
        builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 45.0f, 0.0f, true), new Vector3f(0.4f, 0.4f, 0.4f), null));
        builder.put((Object)ItemTransforms.TransformType.HEAD, (Object)new Transformation(new Vector3f(0.0f, 0.890625f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null));
        builder.put((Object)ItemTransforms.TransformType.GUI, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(30.0f, 45.0f, 0.0f, true), new Vector3f(0.625f, 0.625f, 0.625f), null));
        builder.put((Object)ItemTransforms.TransformType.GROUND, (Object)new Transformation(new Vector3f(0.0f, 0.1875f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.25f, 0.25f, 0.25f), null));
        builder.put((Object)ItemTransforms.TransformType.FIXED, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
        TRANSFORMS = builder.build();
        ITEM_TRANSFORMS = BarrelBakedModelBase.createItemTransforms();
        MOVE_TO_CORNER = new QuadTransformer(new Transformation(new Vector3f(-0.5f, -0.5f, -0.5f), null, null, null));
        DIRECTION_ROTATES = Map.of(Direction.UP, BarrelBakedModelBase.getDirectionRotationTransform(Direction.UP), Direction.DOWN, BarrelBakedModelBase.getDirectionRotationTransform(Direction.DOWN), Direction.NORTH, BarrelBakedModelBase.getDirectionRotationTransform(Direction.NORTH), Direction.SOUTH, BarrelBakedModelBase.getDirectionRotationTransform(Direction.SOUTH), Direction.WEST, BarrelBakedModelBase.getDirectionRotationTransform(Direction.WEST), Direction.EAST, BarrelBakedModelBase.getDirectionRotationTransform(Direction.EAST));
        DIRECTION_MOVES_3D_ITEMS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Direction, Cache<Integer, QuadTransformer>>(){

            public Cache<Integer, QuadTransformer> load(Direction key) {
                return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
            }
        });
        SCALE_BIG_2D_ITEM = new QuadTransformer(new Transformation(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
        SCALE_SMALL_3D_ITEM = new QuadTransformer(new Transformation(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
        SCALE_SMALL_2D_ITEM = new QuadTransformer(new Transformation(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
        DIRECTION_MOVE_BACK_TO_SIDE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        WOOD_NAME = new ModelProperty();
        IS_PACKED = new ModelProperty();
        SHOWS_LOCK = new ModelProperty();
        SHOWS_TIER = new ModelProperty();
        HAS_MAIN_COLOR = new ModelProperty();
        HAS_ACCENT_COLOR = new ModelProperty();
        DISPLAY_ITEMS = new ModelProperty();
        INACCESSIBLE_SLOTS = new ModelProperty();
        BAKED_QUADS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
        DISPLAY_ROTATIONS = new HashMap<Integer, QuadTransformer>();
        MATERIALS = new ModelProperty();
        PARTICLE_ICON_MATERIAL_PRIORITY = List.of(BarrelMaterial.ALL, BarrelMaterial.ALL_BUT_TRIM, BarrelMaterial.TOP_ALL, BarrelMaterial.TOP);
    }

    private static class BarrelItemOverrides
    extends ItemOverrides {
        private final BarrelBakedModelBase barrelBakedModel;
        @Nullable
        private final BakedModel flatTopModel;

        public BarrelItemOverrides(BarrelBakedModelBase barrelBakedModel, @Nullable BakedModel flatTopModel) {
            this.barrelBakedModel = barrelBakedModel;
            this.flatTopModel = flatTopModel;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            boolean flatTop = BarrelBlockItem.isFlatTop(stack);
            if (this.flatTopModel != null && flatTop) {
                return this.flatTopModel.m_7343_().m_173464_(this.flatTopModel, stack, level, entity, seed);
            }
            this.barrelBakedModel.barrelHasMainColor = StorageBlockItem.getMainColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelHasAccentColor = StorageBlockItem.getAccentColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelWoodName = WoodStorageBlockItem.getWoodType(stack).map(WoodType::m_61846_).orElse((String)(this.barrelBakedModel.barrelHasAccentColor && this.barrelBakedModel.barrelHasMainColor ? null : WoodType.f_61833_.m_61846_()));
            this.barrelBakedModel.barrelIsPacked = WoodStorageBlockItem.isPacked(stack);
            this.barrelBakedModel.barrelShowsTier = StorageBlockItem.showsTier(stack);
            this.barrelBakedModel.barrelItem = stack.m_41720_();
            this.barrelBakedModel.flatTop = flatTop;
            this.barrelBakedModel.barrelMaterials = BarrelBlockItem.getMaterials(stack);
            return this.barrelBakedModel;
        }
    }
}

