/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.module;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import com.yungnickyoung.minecraft.yungsextras.YungsExtrasCommon;
import com.yungnickyoung.minecraft.yungsextras.config.YEConfigForge;
import com.yungnickyoung.minecraft.yungsextras.world.WishingWellChances;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigModuleForge {
    public static final String CUSTOM_CONFIG_PATH = "YungsExtras";
    public static final String VERSION_PATH = "forge-1_18";

    public static void init() {
        ConfigModuleForge.initCustomFiles();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)YEConfigForge.SPEC, "YungsExtras-forge-1_18.toml");
        MinecraftForge.EVENT_BUS.addListener(ConfigModuleForge::onWorldLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigModuleForge::onConfigChange);
    }

    private static void onWorldLoad(WorldEvent.Load event) {
        ConfigModuleForge.bakeConfig();
    }

    private static void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == YEConfigForge.SPEC) {
            ConfigModuleForge.bakeConfig();
        }
    }

    private static void initCustomFiles() {
        ConfigModuleForge.createDirectory();
        ConfigModuleForge.createBaseReadMe();
        ConfigModuleForge.createJsonReadMe();
        ConfigModuleForge.loadJSON();
    }

    private static void loadJSON() {
        ConfigModuleForge.loadWishingWellsJSON();
    }

    private static void createDirectory() {
        File parentDir = new File(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH);
        File customConfigDir = new File(parentDir, VERSION_PATH);
        try {
            String filePath = customConfigDir.getCanonicalPath();
            if (customConfigDir.mkdirs()) {
                YungsExtrasCommon.LOGGER.info("Creating directory for additional YUNG's Extras configuration at {}", (Object)filePath);
            }
        }
        catch (IOException e) {
            YungsExtrasCommon.LOGGER.error("ERROR creating YUNG's Extras config directory: {}", (Object)e.toString());
        }
    }

    private static void createBaseReadMe() {
        Path path = Paths.get(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "This directory is for a few additional options for YUNG's Extras.\nOptions provided may vary by version.\nThis directory contains subdirectories for supported versions. The first time you run YUNG's Extras, a version subdirectory will be created if that version supports advanced options.\nFor example, the first time you use YUNG's Extras for MC 1.16 on Forge, the 'forge-1_16' subdirectory will be created in this folder.\nIf no subdirectory for your version is created, then that version probably does not support the additional options.\n\nNOTE -- MOST OPTIONS CAN BE FOUND IN A CONFIG FILE OUTSIDE THIS FOLDER!\nFor example, on Forge 1.16 the file is 'YungsExtras-forge-1_16.toml'.";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Unable to create README file!");
            }
        }
    }

    private static void createJsonReadMe() {
        Path path = Paths.get(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "######################################\n#        wishing_wells.json          #\n######################################\n\nThis file contains a BlockSetSelector (see below) describing the probability of a given block being chosen.\nThese probabilities are used for Wishing Wells, which have \nloot deposits at the bottom of them.\n\n######################################\n#         BlockSetSelectors          #\n######################################\n\nDescribes a set of blockstates and the probability of each blockstate being chosen.\n - entries: An object where each entry's key is a blockstate, and each value is that blockstate's probability of being chosen.\n      The total sum of all probabilities SHOULD NOT exceed 1.0!\n - defaultBlock: The blockstate used for any leftover probability ranges.\n      For example, if the total sum of all the probabilities of the entries is 0.6, then\n      there is a 0.4 chance of the defaultBlock being selected.\n\nHere's an example block selector:\n\"entries\": {\n  \"minecraft:cobblestone\": 0.25,\n  \"minecraft:air\": 0.2,\n  \"minecraft:stone_bricks\": 0.1\n},\n\"defaultBlock\": \"minecraft:oak_planks\"\n\nFor each block, this selector has a 25% chance of returning cobblestone, 20% chance of choosing air,\n10% chance of choosing stone bricks, and a 100 - (25 + 20 + 10) = 45% chance of choosing oak planks (since it's the default block).\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Unable to create wishing wells README file!");
            }
        }
    }

    private static void loadWishingWellsJSON() {
        Path jsonPath = Paths.get(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "wishing_wells.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)WishingWellChances.get());
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Unable to create wishing_wells.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                YungsExtrasCommon.LOGGER.error("YUNG's Extras wishing_wells.json file not readable! Using default configuration...");
                return;
            }
            try {
                WishingWellChances.instance = (WishingWellChances)JSON.loadObjectFromJsonFile((Path)jsonPath, WishingWellChances.class);
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Error loading YUNG's Extras wishing_wells.json file: {}", (Object)e.toString());
                YungsExtrasCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void bakeConfig() {
        YungsExtrasCommon.CONFIG.desert.wells.smallNormalWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.smallNormalWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.mediumNormalWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.mediumNormalWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.largeNormalWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.largeNormalWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.smallWishingWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.smallWishingWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.mediumWishingWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.mediumWishingWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.largeWishingWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.largeWishingWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.smallDryWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.smallDryWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.mediumDryWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.mediumDryWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.wells.largeDryWellSpawnRate = (Integer)YEConfigForge.desertDecorations.wells.largeDryWellSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.obelisks.normalObeliskSpawnRate = (Integer)YEConfigForge.desertDecorations.obelisks.normalObeliskSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.obelisks.creeperObeliskSpawnRate = (Integer)YEConfigForge.desertDecorations.obelisks.creeperObeliskSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.obelisks.ruinedObeliskSpawnRate = (Integer)YEConfigForge.desertDecorations.obelisks.ruinedObeliskSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.obelisks.blackstoneObeliskSpawnRate = (Integer)YEConfigForge.desertDecorations.obelisks.blackstoneObeliskSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.misc.smallRuinsSpawnRate = (Integer)YEConfigForge.desertDecorations.misc.smallRuinsSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.misc.giantTorchSpawnRate = (Integer)YEConfigForge.desertDecorations.misc.giantTorchSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.misc.chillzoneSpawnRate = (Integer)YEConfigForge.desertDecorations.misc.chillzoneSpawnRate.get();
        YungsExtrasCommon.CONFIG.swamp.pillarSpawnRate = (Integer)YEConfigForge.swamp.pillarSpawnRate.get();
        YungsExtrasCommon.CONFIG.swamp.ogreSpawnRate = (Integer)YEConfigForge.swamp.ogreSpawnRate.get();
        YungsExtrasCommon.CONFIG.swamp.cubbySpawnRate = (Integer)YEConfigForge.swamp.cubbySpawnRate.get();
        YungsExtrasCommon.CONFIG.swamp.archSpawnRate = (Integer)YEConfigForge.swamp.archSpawnRate.get();
        YungsExtrasCommon.CONFIG.swamp.doubleArchSpawnRate = (Integer)YEConfigForge.swamp.doubleArchSpawnRate.get();
        YungsExtrasCommon.CONFIG.swamp.churchSpawnRate = (Integer)YEConfigForge.swamp.churchSpawnRate.get();
        YungsExtrasCommon.CONFIG.desert.additionalBiomeWhitelist = ConfigModuleForge.parseList((String)YEConfigForge.desertDecorations.additionalBiomeWhitelist.get(), "Additional Biome Whitelist (Desert)");
        YungsExtrasCommon.CONFIG.desert.biomeBlacklist = ConfigModuleForge.parseList((String)YEConfigForge.desertDecorations.biomeBlacklist.get(), "Biome Blacklist (Desert)");
        YungsExtrasCommon.CONFIG.swamp.additionalBiomeWhitelist = ConfigModuleForge.parseList((String)YEConfigForge.swamp.additionalBiomeWhitelist.get(), "Additional Biome Whitelist (Swamp)");
        YungsExtrasCommon.CONFIG.swamp.biomeBlacklist = ConfigModuleForge.parseList((String)YEConfigForge.swamp.biomeBlacklist.get(), "Biome Blacklist (Swamp)");
    }

    private static List<String> parseList(String rawStringOfList, String settingName) {
        int strLen = rawStringOfList.length();
        if (strLen < 2 || rawStringOfList.charAt(0) != '[' || rawStringOfList.charAt(strLen - 1) != ']') {
            YungsExtrasCommon.LOGGER.error("INVALID VALUE FOR SETTING '" + settingName + "'. Using empty list instead...");
            return new ArrayList<String>();
        }
        return Lists.newArrayList((Object[])rawStringOfList.substring(1, strLen - 1).split(",\\s*"));
    }
}

