/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_texture_loading;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextureAtlas.class}, priority=600)
@ClientOnlyMixin
public abstract class TextureAtlasMixin {
    private Map<ResourceLocation, Pair<Resource, NativeImage>> loadedImages = new ConcurrentHashMap<ResourceLocation, Pair<Resource, NativeImage>>();
    private boolean usingFasterLoad;
    private Collection<TextureAtlasSprite.Info> storedResults;

    @Shadow
    protected abstract ResourceLocation m_118324_(ResourceLocation var1);

    @Shadow
    protected abstract Collection<TextureAtlasSprite.Info> m_118304_(ResourceManager var1, Set<ResourceLocation> var2);

    @Inject(method={"getBasicSpriteInfos"}, at={@At(value="HEAD")})
    private void loadImages(ResourceManager manager, Set<ResourceLocation> imageLocations, CallbackInfoReturnable<Collection<TextureAtlasSprite.Info>> cir) {
        this.usingFasterLoad = ModernFixPlatformHooks.INSTANCE.isLoadingNormally();
    }

    @Redirect(method={"getBasicSpriteInfos"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;", ordinal=0))
    private Iterator<?> skipIteration(Set<?> instance, ResourceManager manager, Set<ResourceLocation> imageLocations) {
        if (!this.usingFasterLoad) {
            return instance.iterator();
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ConcurrentLinkedQueue<TextureAtlasSprite.Info> results = new ConcurrentLinkedQueue<TextureAtlasSprite.Info>();
        for (ResourceLocation location : imageLocations) {
            if (MissingTextureAtlasSprite.m_118071_().equals((Object)location)) continue;
            futures.add(CompletableFuture.runAsync(() -> {
                try {
                    ResourceLocation fileLocation = this.m_118324_(location);
                    Resource resource = manager.m_142591_(fileLocation);
                    NativeImage image = NativeImage.m_85058_((InputStream)resource.m_6679_());
                    AnimationMetadataSection animData = (AnimationMetadataSection)resource.m_5507_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_);
                    if (animData == null) {
                        animData = AnimationMetadataSection.f_119012_;
                    }
                    Pair dimensions = animData.m_7117_(image.m_84982_(), image.m_85084_());
                    this.loadedImages.put(location, (Pair<Resource, NativeImage>)Pair.of((Object)resource, (Object)image));
                    results.add(new TextureAtlasSprite.Info(location, ((Integer)dimensions.getFirst()).intValue(), ((Integer)dimensions.getSecond()).intValue(), animData));
                }
                catch (IOException e) {
                    ModernFix.LOGGER.error("Using missing texture, unable to load {} : {}", (Object)location, (Object)e);
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Unable to parse metadata from {} : {}", (Object)location, (Object)e);
                }
            }, ModernFix.resourceReloadExecutor()));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        this.storedResults = results;
        return Collections.emptyIterator();
    }

    @Inject(method={"getBasicSpriteInfos"}, at={@At(value="RETURN")})
    private void injectFastSprites(ResourceManager resourceManager, Set<ResourceLocation> spriteLocations, CallbackInfoReturnable<Collection<TextureAtlasSprite.Info>> cir) {
        if (this.usingFasterLoad) {
            ((Collection)cir.getReturnValue()).addAll(this.storedResults);
        }
    }

    @Inject(method={"prepareToStitch"}, at={@At(value="HEAD")})
    private void initMap(CallbackInfoReturnable<TextureAtlas.Preparations> cir) {
        this.loadedImages = new ConcurrentHashMap<ResourceLocation, Pair<Resource, NativeImage>>();
    }

    @Inject(method={"prepareToStitch"}, at={@At(value="RETURN")})
    private void clearLoadedImages(CallbackInfoReturnable<TextureAtlas.Preparations> cir) {
        this.loadedImages = Collections.emptyMap();
        this.storedResults = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlas;getResourceLocation(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/resources/ResourceLocation;")}, cancellable=true)
    private void loadFromExisting(ResourceManager resourceManager, TextureAtlasSprite.Info spriteInfo, int storageX, int storageY, int mipLevel, int x, int y, CallbackInfoReturnable<TextureAtlasSprite> cir) {
        if (!this.usingFasterLoad) {
            return;
        }
        Pair<Resource, NativeImage> pair = this.loadedImages.get(spriteInfo.m_118431_());
        if (pair == null) {
            ModernFix.LOGGER.error("Texture {} was not loaded in early stage", (Object)spriteInfo.m_118431_());
            cir.setReturnValue(null);
        } else {
            TextureAtlasSprite sprite = null;
            try {
                sprite = ModernFixPlatformHooks.INSTANCE.loadTextureAtlasSprite((TextureAtlas)this, resourceManager, spriteInfo, (Resource)pair.getFirst(), storageX, storageY, x, y, mipLevel, (NativeImage)pair.getSecond());
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Error loading texture {}: {}", (Object)spriteInfo.m_118431_(), (Object)e);
            }
            finally {
                try {
                    ((Resource)pair.getFirst()).close();
                }
                catch (IOException iOException) {}
            }
            cir.setReturnValue(sprite);
        }
    }
}

