/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import org.apache.commons.compress.utils.Lists;

public class ModEnchantTableRenderer
extends EnchantTableRenderer {
    public ModEnchantTableRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EnchantingTableBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        super.render(blockEntity, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        Container container = (Container)blockEntity;
        ItemStack itemToEnchant = container.getItem(0);
        ItemStack enchantingStack = container.getItem(1);
        ItemStack rerollStack = container.getItem(2);
        int posData = (int)blockEntity.getBlockPos().asLong();
        switch (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).renderEnchantingTableContents) {
            case FLAT: {
                List<ItemStack> items = ModEnchantTableRenderer.getItemsList(itemToEnchant, enchantingStack, rerollStack);
                this.renderFlatItemList(items, blockEntity.getBlockPos(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn, blockEntity.getLevel(), posData);
                break;
            }
            case FLOATING: {
                List<ItemStack> items = ModEnchantTableRenderer.getItemsList(ItemStack.EMPTY, enchantingStack, rerollStack);
                this.renderHoveringItem(blockEntity, itemToEnchant, partialTicks, poseStack, bufferIn, combinedLightIn);
                this.renderHoveringItemList(items, (float)blockEntity.time + partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, true, blockEntity.getLevel(), posData);
            }
        }
    }

    private static List<ItemStack> getItemsList(ItemStack itemToEnchant, ItemStack enchantingStack, ItemStack rerollStack) {
        ArrayList items = Lists.newArrayList();
        items.add(itemToEnchant);
        for (int i = 0; i < 3; ++i) {
            if (i < enchantingStack.getCount()) {
                items.add(enchantingStack);
            }
            if (i >= rerollStack.getCount()) continue;
            items.add(rerollStack);
        }
        items.removeIf(ItemStack::isEmpty);
        return items;
    }

    private void renderFlatItemList(List<ItemStack> items, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Level level, int posData) {
        int randomDirection = Math.abs(pos.getX() + pos.getZ()) % 4;
        for (int i = 0; i < Math.min(4, items.size()); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.76171875, 0.5);
            Direction direction = Direction.from2DDataValue((int)((i + randomDirection) % 4));
            float horizontalAngle = -direction.toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(horizontalAngle));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(-0.3125, -0.3125, 0.0);
            poseStack.scale(0.375f, 0.375f, 0.375f);
            ItemStack renderStack = items.get(i);
            Minecraft.getInstance().getItemRenderer().renderStatic(renderStack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, level, posData + i);
            poseStack.popPose();
        }
    }

    private void renderHoveringItem(EnchantingTableBlockEntity blockEntity, ItemStack itemToEnchant, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (blockEntity.open == 0.0f && blockEntity.oOpen == 0.0f) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.0f, 0.5f);
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(itemToEnchant, blockEntity.getLevel(), null, 0);
        float hoverOffset = Mth.sin((float)(((float)blockEntity.time + partialTicks) / 10.0f)) * 0.1f + 0.1f;
        float modelYScale = model.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        float openness = Mth.lerp((float)partialTicks, (float)blockEntity.oOpen, (float)blockEntity.open);
        poseStack.translate(0.0, (double)(hoverOffset + 0.25f * modelYScale * openness - 0.15f * (1.0f - openness)), 0.0);
        float scale = openness * 0.8f + 0.2f;
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotation(((float)blockEntity.time + partialTicks) / 20.0f));
        Minecraft.getInstance().getItemRenderer().render(itemToEnchant, ItemDisplayContext.GROUND, false, poseStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
    }

    private void renderHoveringItemList(List<ItemStack> items, float age, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, boolean rotateItems, Level level, int posData) {
        float itemRenderAngle = 360.0f / (float)items.size();
        for (int i = 0; i < items.size(); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.0f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)i * itemRenderAngle + age));
            poseStack.translate(0.75f, 0.0f, 0.25f);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotateItems ? age % 360.0f : 90.0f));
            poseStack.translate(0.0, 0.075 * Math.sin(((double)age + (double)i * 10.0) / 5.0), 0.0);
            Minecraft.getInstance().getItemRenderer().renderStatic(items.get(i), ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, level, posData + i);
            poseStack.popPose();
        }
    }
}

