/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.gui.screens.inventory;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.client.gui.components.EnchantmentSlotButton;
import fuzs.easymagic.client.gui.components.RerollButton;
import fuzs.easymagic.client.util.EnchantmentTooltipHelper;
import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class ModEnchantmentScreen
extends EnchantmentScreen {
    private static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot");
    private boolean noTooltipRendering;

    public ModEnchantmentScreen(EnchantmentMenu enchantmentMenu, Inventory inventory, Component title) {
        super(enchantmentMenu, inventory, title);
    }

    public void containerTick() {
        super.containerTick();
        this.tickChildren();
    }

    public void tickChildren() {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!(guiEventListener instanceof Tickable)) continue;
            Tickable tickable = (Tickable)guiEventListener;
            tickable.tick();
        }
    }

    protected void init() {
        super.init();
        for (int i = 0; i < 3; ++i) {
            int slotIndex = i;
            AbstractWidget enchantmentSlotButton = (AbstractWidget)this.addRenderableWidget((GuiEventListener)new EnchantmentSlotButton(this.leftPos + 60, this.topPos + 14 + 19 * i, button -> {
                if (((EnchantmentMenu)this.menu).clickMenuButton((Player)this.minecraft.player, slotIndex)) {
                    this.minecraft.gameMode.handleInventoryButtonClick(((EnchantmentMenu)this.menu).containerId, slotIndex);
                }
            }, DISABLED_LEVEL_SPRITES[i], ENABLED_LEVEL_SPRITES[i], i, this.getMenu()));
            TooltipBuilder.create().setLines(() -> {
                List<EnchantmentInstance> slotData = this.getMenu().clues.get(slotIndex);
                if (!slotData.isEmpty()) {
                    ArrayList<Component> tooltipLines = new ArrayList<Component>();
                    EnchantmentTooltipHelper.gatherSlotEnchantmentsTooltip(slotData, tooltipLines::add, (HolderLookup.Provider)this.minecraft.getConnection().registryAccess());
                    EnchantmentTooltipHelper.gatherSlotCostsTooltip(slotIndex, tooltipLines, (Player)this.minecraft.player, this.getMenu());
                    return tooltipLines;
                }
                return Collections.emptyList();
            }).build(enchantmentSlotButton);
        }
        AbstractWidget rerollButton = (AbstractWidget)this.addRenderableWidget((GuiEventListener)new RerollButton(this.getRerollButtonX(), this.getRerollButtonY(), button -> {
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && ((EnchantmentMenu)this.menu).clickMenuButton((Player)this.minecraft.player, 4)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((EnchantmentMenu)this.menu).containerId, 4);
            }
        }, this.getMenu()));
        TooltipBuilder.create().setLines(() -> {
            ArrayList<Component> tooltipLines = new ArrayList<Component>();
            EnchantmentTooltipHelper.gatherRerollTooltip(tooltipLines, (Player)this.minecraft.player, this.getMenu());
            return tooltipLines;
        }).build(rerollButton);
        this.tickChildren();
    }

    private int getRerollButtonX() {
        return this.leftPos + (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 12 : 14);
    }

    private int getRerollButtonY() {
        return this.topPos + 16;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(ENCHANTING_TABLE_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderBook(guiGraphics, this.leftPos, this.topPos, partialTick);
        EnchantmentNames.getInstance().initSeed((long)((EnchantmentMenu)this.menu).getEnchantmentSeed());
        for (int i = 0; i < 3; ++i) {
            guiGraphics.blitSprite(ENCHANTMENT_SLOT_DISABLED_SPRITE, this.leftPos + 60, this.topPos + 14 + 19 * i, 108, 19);
        }
        if (!((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).keepEnchantmentScreenBook()) {
            guiGraphics.blit(RerollButton.ENCHANTING_TABLE_REROLL_LOCATION, this.getRerollButtonX(), this.getRerollButtonY(), 0.0f, 0.0f, 38, 27, 256, 256);
        }
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst()) {
            guiGraphics.blit(ENCHANTING_TABLE_LOCATION, this.leftPos + 4, this.topPos + 46, 14.0f, 46.0f, 18, 18, 256, 256);
            guiGraphics.blit(ENCHANTING_TABLE_LOCATION, this.leftPos + 22, this.topPos + 46, 34.0f, 46.0f, 18, 18, 256, 256);
            guiGraphics.blitSprite(SLOT_SPRITE, this.leftPos + 40, this.topPos + 46, 18, 18);
        }
    }

    protected void renderBook(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        if (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).keepEnchantmentScreenBook()) {
            super.renderBook(guiGraphics, x, y, partialTick);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.noTooltipRendering = true;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.noTooltipRendering = false;
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public ModEnchantmentMenu getMenu() {
        return (ModEnchantmentMenu)super.getMenu();
    }

    public static EventResult onRenderTooltip(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY, List<ClientTooltipComponent> components, ClientTooltipPositioner positioner) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ModEnchantmentScreen) {
            ModEnchantmentScreen screen2 = (ModEnchantmentScreen)screen;
            if (screen2.noTooltipRendering) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }
}

