/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.mehvahdjukaar.fastpaintings.FastPaintings;
import net.mehvahdjukaar.fastpaintings.NBTDropMode;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintingBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    protected static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final IntegerProperty DOWN_OFFSET = IntegerProperty.create((String)"y_offset", (int)0, (int)15);
    protected static final IntegerProperty RIGHT_OFFSET = IntegerProperty.create((String)"x_offset", (int)0, (int)15);

    public PaintingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN_OFFSET, (Comparable)Integer.valueOf(0))).setValue((Property)RIGHT_OFFSET, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
        if (m != null && !m.hasDroppedItemHack) {
            m.hasDroppedItemHack = true;
            Vec3 v = m.getPaintingDropLocation();
            ItemStack painting = this.getCloneItemStack((LevelReader)level, pos, state);
            Containers.dropItemStack((Level)level, (double)v.x, (double)v.y, (double)v.z, (ItemStack)painting);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
        if (m != null && !m.hasDroppedItemHack) {
            m.hasDroppedItemHack = true;
            if (!player.isCreative()) {
                ItemStack painting = this.getCloneItemStack((LevelReader)level, pos, state);
                Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)painting);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return super.getDrops(state, params);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
        if (m != null) {
            return PaintingBlock.getPaintingItem(level, m.getVariant(), m.isPlacedWithNbt());
        }
        return new ItemStack((ItemLike)Items.PAINTING);
    }

    public static ItemStack getPaintingItem(LevelReader level, Holder<PaintingVariant> variant, boolean wasPlacedWithNbt) {
        NBTDropMode mode = FastPaintings.SPECIAL_DROP.get();
        ItemStack itemStack = new ItemStack((ItemLike)Items.PAINTING);
        if (mode == NBTDropMode.OFF || mode == NBTDropMode.WHEN_PLACED_WITH_NBT && !wasPlacedWithNbt) {
            return itemStack;
        }
        CompoundTag compoundTag = new CompoundTag();
        Painting.VARIANT_CODEC.encodeStart((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), variant).ifSuccess(tag -> compoundTag.merge((CompoundTag)tag));
        compoundTag.putString("id", "minecraft:painting");
        itemStack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
        return itemStack;
    }

    public boolean isPossibleToRespawnInThis(BlockState blockState) {
        return true;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        if (context instanceof EntityCollisionContext && !((ec = (EntityCollisionContext)context).getEntity() instanceof HangingEntity)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, DOWN_OFFSET, RIGHT_OFFSET});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public BlockState updateShape(BlockState stateIn, Direction updateDir, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction dir = (Direction)stateIn.getValue((Property)FACING);
        if (updateDir.getOpposite() == dir && !facingState.isSolid() && !DiodeBlock.isDiode((BlockState)facingState)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, updateDir, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
        if (m != null) {
            pos = m.getBlockPos();
            Direction dir = (Direction)state.getValue((Property)FACING);
            Holder<PaintingVariant> variant = m.getVariant();
            int width = PaintingBlock.getWidth(variant);
            int height = PaintingBlock.getHeight(variant);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    BlockPos p = pos.below(y).relative(dir.getCounterClockWise(), x);
                    BlockState b = level.getBlockState(p);
                    if (b.is((Block)this) && b.getValue((Property)FACING) == dir && (Integer)b.getValue((Property)DOWN_OFFSET) == y && (Integer)b.getValue((Property)RIGHT_OFFSET) == x) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
            if (m != null) {
                pos = m.getBlockPos();
                Direction dir = (Direction)state.getValue((Property)FACING);
                Holder<PaintingVariant> variant = m.getVariant();
                int width = PaintingBlock.getWidth(variant);
                int height = PaintingBlock.getHeight(variant);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        BlockPos p = pos.below(y).relative(dir.getCounterClockWise(), x);
                        if (!level.getBlockState(p).is((Block)this)) continue;
                        level.removeBlock(p, false);
                    }
                }
            } else {
                level.removeBlock(pos, false);
            }
        }
    }

    private static int getHeight(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.value()).height();
    }

    private static int getWidth(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.value()).width();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return PaintingBlock.isMaster(state) ? new PaintingBlockEntity(pos, state) : null;
    }

    public static boolean tryConverting(Painting entity, @Nullable ItemStack stack) {
        BlockPos p;
        Level level = entity.level();
        Direction dir = entity.getDirection();
        Holder variant = entity.getVariant();
        int width = PaintingBlock.getWidth((Holder<PaintingVariant>)variant);
        int height = PaintingBlock.getHeight((Holder<PaintingVariant>)variant);
        if (width > 5 || height > 5) {
            return false;
        }
        AABB bb = entity.getBoundingBox();
        BlockPos pos = switch (dir) {
            case Direction.SOUTH -> BlockPos.containing((double)bb.minX, (double)(bb.maxY - 0.5), (double)bb.maxZ);
            case Direction.WEST -> BlockPos.containing((double)bb.minX, (double)(bb.maxY - 0.5), (double)bb.minZ);
            case Direction.EAST -> BlockPos.containing((double)bb.maxX, (double)(bb.maxY - 0.5), (double)(bb.maxZ - 0.5));
            default -> BlockPos.containing((double)(bb.maxX - 0.5), (double)(bb.maxY - 0.5), (double)bb.minZ);
        };
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                p = pos.below(y).relative(dir.getCounterClockWise(), x);
                if (level.getBlockState(p).isAir()) continue;
                return false;
            }
        }
        if (level.getBlockState(pos).isAir()) {
            BlockState state = (BlockState)FastPaintings.PAINTING_BLOCK.get().defaultBlockState().setValue((Property)FACING, (Comparable)dir);
            level.setBlock(pos, state, 2);
            p = level.getBlockEntity(pos);
            if (p instanceof PaintingBlockEntity) {
                DataResult variant2;
                CustomData tag;
                PaintingBlockEntity pe = (PaintingBlockEntity)p;
                pe.setVariant((Holder<PaintingVariant>)variant);
                if (stack != null && (tag = (CustomData)stack.get(DataComponents.ENTITY_DATA)) != null && (variant2 = Painting.VARIANT_CODEC.parse((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.copyTag())).isSuccess() && ((Holder)variant2.getOrThrow()).value() == variant.value()) {
                    pe.setPlacedWithNbt(true);
                }
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (x == 0 && y == 0) continue;
                        BlockPos p2 = pos.below(y).relative(dir.getCounterClockWise(), x);
                        level.setBlock(p2, (BlockState)((BlockState)state.setValue((Property)DOWN_OFFSET, (Comparable)Integer.valueOf(y))).setValue((Property)RIGHT_OFFSET, (Comparable)Integer.valueOf(x)), 2);
                    }
                }
                pe.requestModelReload();
                entity.discard();
                return true;
            }
        }
        return false;
    }

    public static boolean isMaster(BlockState state) {
        return (Integer)state.getValue((Property)DOWN_OFFSET) == 0 && (Integer)state.getValue((Property)RIGHT_OFFSET) == 0;
    }

    public static PaintingBlockEntity getMaster(BlockState state, BlockPos pos, BlockAndTintGetter level) {
        Level l;
        BlockPos masterPos = PaintingBlock.getMasterPos(state, pos);
        if (level instanceof Level && !(l = (Level)level).isLoaded(pos)) {
            return null;
        }
        BlockEntity e = level.getBlockEntity(masterPos);
        if (e instanceof PaintingBlockEntity) {
            PaintingBlockEntity pe = (PaintingBlockEntity)e;
            return pe;
        }
        return null;
    }

    @NotNull
    private static BlockPos getMasterPos(BlockState state, BlockPos pos) {
        int y = (Integer)state.getValue((Property)DOWN_OFFSET);
        int x = (Integer)state.getValue((Property)RIGHT_OFFSET);
        Direction facing = (Direction)state.getValue((Property)FACING);
        return pos.above(y).relative(facing.getClockWise(), x);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction direction) {
        if (adjacentBlockState.is((Block)this) && adjacentBlockState.getValue((Property)FACING) == state.getValue((Property)FACING)) {
            return true;
        }
        return state.getValue((Property)FACING) == direction || super.skipRendering(state, adjacentBlockState, direction);
    }
}

