/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.smithingtemplateviewer.emi;

import com.buuz135.smithingtemplateviewer.Config;
import com.buuz135.smithingtemplateviewer.SmithingTrimWrapper;
import com.buuz135.smithingtemplateviewer.emi.STVEmiPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EMISmithingViewerRecipe
implements EmiRecipe {
    public final ResourceLocation id;
    public final SmithingTrimWrapper wrapper;

    public EMISmithingViewerRecipe(ResourceLocation id, SmithingTrimWrapper wrapper) {
        this.id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("/" + id.getPath() + "_viewer"));
        this.wrapper = wrapper;
    }

    public EmiRecipeCategory getCategory() {
        return STVEmiPlugin.CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        if (((Boolean)Config.CONFIG.displayMaterials.get()).booleanValue()) {
            return List.of(EmiIngredient.of((Ingredient)this.wrapper.getRecipe().template), EmiIngredient.of((Ingredient)this.wrapper.getRecipe().base), EmiIngredient.of((Ingredient)this.wrapper.getRecipe().addition));
        }
        ItemStack itemStack = Items.BARRIER.getDefaultInstance();
        itemStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Use any item!"));
        return List.of(EmiIngredient.of((Ingredient)this.wrapper.getRecipe().template), EmiIngredient.of((Ingredient)this.wrapper.getRecipe().base), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{itemStack})));
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return 120;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.getInputs().get(0), 0, 0);
        widgets.addSlot(this.getInputs().get(1), 0, 18);
        widgets.addSlot(this.getInputs().get(2), 0, 36);
        int armorStandX = 75;
        int armorStandY = 75;
        widgets.addDrawable(0, 0, 0, 0, (guiGraphics, mouseX, mouseY, delta) -> {
            Vector3f ARMOR_STAND_TRANSLATION = new Vector3f();
            Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);
            ItemStack template = this.wrapper.getRecipe().template.getItems()[0];
            Item patt0$temp = template.getItem();
            if (patt0$temp instanceof SmithingTemplateItem) {
                SmithingTemplateItem templateItem = (SmithingTemplateItem)patt0$temp;
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)templateItem.upgradeDescription.copy().withStyle(ChatFormatting.DARK_GRAY), 20, 5, 0xFFFFFF, false);
            }
            ResourceLocation inventory = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/inventory.png");
            ResourceLocation buttons = ResourceLocation.fromNamespaceAndPath((String)"smithingtemplateviewer", (String)"textures/gui/buttons.png");
            guiGraphics.blit(inventory, armorStandX - 25, armorStandY - 57, 25, 7, 51, 72);
            InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)armorStandX, (float)armorStandY, (float)25.0f, (Vector3f)ARMOR_STAND_TRANSLATION, (Quaternionf)ARMOR_STAND_ANGLE, null, (LivingEntity)this.wrapper.getArmorStand());
            guiGraphics.renderItem(this.wrapper.getRecipe().addition.getItems()[this.wrapper.getColorIndex()], armorStandX - 24 + 17, armorStandY + 20);
        });
        for (int i = 0; i < 4; ++i) {
            int finalI = i;
            widgets.addButton(armorStandX - 25 - 16, armorStandY - 57 + 4 + 18 * i, 12, 12, 0, 0, () -> this.wrapper.getArmorIndex()[finalI] > 0, (mouseX, mouseY, button) -> {
                if (this.wrapper.getArmorIndex()[finalI] > 0) {
                    int[] nArray = this.wrapper.getArmorIndex();
                    int n = finalI;
                    nArray[n] = nArray[n] - 1;
                    this.wrapper.updateArmorStand((Level)Minecraft.getInstance().level);
                }
            });
            widgets.addButton(armorStandX + 25 + 4, armorStandY - 57 + 4 + 18 * i, 12, 12, 12, 0, () -> this.wrapper.getArmorIndex()[finalI] < this.wrapper.getArmors().get(finalI).size(), (mouseX, mouseY, button) -> {
                if (this.wrapper.getArmorIndex()[finalI] < this.wrapper.getArmors().get(finalI).size()) {
                    int[] nArray = this.wrapper.getArmorIndex();
                    int n = finalI;
                    nArray[n] = nArray[n] + 1;
                    this.wrapper.updateArmorStand((Level)Minecraft.getInstance().level);
                }
            });
        }
        widgets.addButton(armorStandX - 22, armorStandY + 22, 12, 12, 0, 0, () -> this.wrapper.getColorIndex() > 0, (mouseX, mouseY, button) -> {
            if (this.wrapper.getColorIndex() > 0) {
                this.wrapper.setColorIndex(this.wrapper.getColorIndex() - 1);
                this.wrapper.updateArmorStand((Level)Minecraft.getInstance().level);
            }
        });
        widgets.addButton(armorStandX + 12, armorStandY + 22, 12, 12, 12, 0, () -> this.wrapper.getColorIndex() < this.wrapper.getRecipe().addition.getItems().length - 1, (mouseX, mouseY, button) -> {
            if (this.wrapper.getColorIndex() < this.wrapper.getRecipe().addition.getItems().length - 1) {
                this.wrapper.setColorIndex(this.wrapper.getColorIndex() + 1);
                this.wrapper.updateArmorStand((Level)Minecraft.getInstance().level);
            }
        });
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

