/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PlayerUtils {
    public static EntityHitResult getEntityLookingAt(Player player, float distance) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 targetPos = eyePos.add(lookVec.scale((double)distance));
        AABB rayTraceBox = new AABB(eyePos, targetPos);
        return ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)eyePos, (Vec3)targetPos, (AABB)rayTraceBox, entity -> !entity.isSpectator() && entity instanceof LivingEntity && entity.isPickable(), (float)0.3f);
    }

    public static BlockHitResult getBlockLookingAt(Player player, float distance) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 targetPos = eyePos.add(lookVec.scale((double)distance));
        ClipContext clipContext = new ClipContext(eyePos, targetPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return player.level().clip(clipContext);
    }

    public static boolean isBlockNearby(ServerPlayer player, TagKey<Block> blockTag, int radius) {
        BlockPos playerPos = player.blockPosition();
        ServerLevel level = player.serverLevel();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos checkPos = playerPos.offset(dx, dy, dz);
                    if (!level.getBlockState(checkPos).is(blockTag)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasPokemon(ServerPlayer player, String pokemon) {
        if (player == null) {
            return true;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        for (Pokemon partyPokemon : playerPartyStore) {
            if (!partyPokemon.getSpecies().getName().equals(pokemon)) continue;
            return true;
        }
        return false;
    }

    public static Pokemon getPartyPokemonFromUUID(ServerPlayer player, UUID uuid) {
        if (player == null) {
            return null;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        for (Pokemon partyPokemon : playerPartyStore) {
            if (partyPokemon.getEntity() == null || !partyPokemon.getEntity().getUUID().equals(uuid)) continue;
            return partyPokemon;
        }
        return null;
    }

    public static Pokemon getPCPokemonFromUUID(ServerPlayer player, UUID uuid) {
        if (player == null) {
            return null;
        }
        PCStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getPC(player);
        for (Pokemon partyPokemon : playerPartyStore) {
            if (!partyPokemon.getUuid().equals(uuid)) continue;
            return partyPokemon;
        }
        return null;
    }
}

