/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.screen.custom.handler;

import com.github.yajatkaul.mega_showdown.components.InventoryStorage;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.screen.MegaShowdownMenuTypes;
import com.github.yajatkaul.mega_showdown.screen.custom.slot.ZygardeSlots;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ZygardeCubesScreenHandler
extends AbstractContainerMenu {
    private final ItemStack cube;
    private final InventoryStorage inventoryStorage;
    private final SimpleContainer cubeInv;
    private final Level level;

    public ZygardeCubesScreenHandler(int id, Inventory inv) {
        this(id, inv, ItemStack.EMPTY, null);
    }

    public ZygardeCubesScreenHandler(int id, Inventory inv, ItemStack cube, Level level) {
        super((MenuType)MegaShowdownMenuTypes.ZYGARDE_CUBE_MENU.get(), id);
        this.cube = cube;
        this.level = level;
        this.inventoryStorage = (InventoryStorage)cube.getOrDefault(MegaShowdownDataComponents.INVENTORY.get(), (Object)InventoryStorage.defaultStorage(2));
        this.cubeInv = level != null ? this.inventoryStorage.getInventory((HolderLookup.Provider)level.registryAccess()) : new SimpleContainer(2);
        this.addSlot(new ZygardeSlots((Container)this.cubeInv, 0, 62, 36));
        this.addSlot(new ZygardeSlots((Container)this.cubeInv, 1, 98, 36));
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.cubeInv.getContainerSize() ? !this.moveItemStackTo(originalStack, this.cubeInv.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.cubeInv.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.slots.size() && (slot = (Slot)this.slots.get(slotId)).hasItem() && slot.getItem() == this.cube) {
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.level != null) {
            this.cube.set(MegaShowdownDataComponents.INVENTORY.get(), (Object)this.inventoryStorage.save((HolderLookup.Provider)this.level.registryAccess(), this.cubeInv));
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

