/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render.accessories;

import com.github.yajatkaul.mega_showdown.tag.MegaShowdownTags;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HighOffHandRenderer
implements AccessoryRenderer {
    public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack poseStack, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        HumanoidArm offHandArm;
        LivingEntity entity = reference.entity();
        ItemStack handStack = entity.getItemInHand(entity.getUsedItemHand());
        if (handStack.is(MegaShowdownTags.Items.Z_RING)) {
            return;
        }
        poseStack.pushPose();
        HumanoidArm humanoidArm = offHandArm = entity.getMainArm() == HumanoidArm.RIGHT ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        if (model instanceof ArmedModel) {
            ArmedModel armedModel = (ArmedModel)model;
            armedModel.translateToHand(offHandArm, poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            if (offHandArm == HumanoidArm.RIGHT) {
                poseStack.translate(0.0625f, 0.125f, -0.5f);
            } else {
                poseStack.translate(-0.0625f, 0.125f, -0.5f);
            }
        }
        ItemDisplayContext context = offHandArm == HumanoidArm.LEFT ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        Minecraft.getInstance().getItemRenderer().renderStatic(entity, stack, context, offHandArm == HumanoidArm.LEFT, poseStack, multiBufferSource, entity.level(), light, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }
}

