/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render.accessories;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HeadRenderer
implements AccessoryRenderer {
    public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack poseStack, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        poseStack.pushPose();
        LivingEntity entity = reference.entity();
        ItemStack headArmor = entity.getItemBySlot(EquipmentSlot.HEAD);
        float z_axis = 0.0f;
        if (!headArmor.isEmpty()) {
            z_axis = -0.05f;
        }
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            humanoidModel.head.translateAndRotate(poseStack);
        } else if (model instanceof EntityModel) {
            poseStack.translate(0.0f, 0.25f, z_axis);
        }
        poseStack.translate(0.0f, -0.25f, z_axis);
        poseStack.scale(0.625f, 0.625f, 0.625f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        Minecraft.getInstance().getItemRenderer().renderStatic(entity, stack, ItemDisplayContext.HEAD, false, poseStack, multiBufferSource, entity.level(), light, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }
}

