/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.neoforge.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.neoforge.utils.KotlinHelperNeo;
import com.github.yajatkaul.mega_showdown.utils.TeraHelper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonClientDelegate.class}, remap=false)
public class PokemonClientDelegateMixin {
    @Shadow
    public PokemonEntity currentEntity;
    @Unique
    private long mega_showdown$lastTeraParticle;
    @Unique
    private final float mega_showdown$teraParticleCooldown = 2.0f;

    @Unique
    private float mega_showdown$secondsSinceLastTeraParticle() {
        return (float)(System.currentTimeMillis() - this.mega_showdown$lastTeraParticle) / 1000.0f;
    }

    @Inject(method={"tick(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V"}, at={@At(value="TAIL")})
    private void tick(PokemonEntity entity, CallbackInfo ci) {
        this.mega_showdown$playTera();
    }

    @Unique
    private void mega_showdown$playTera() {
        PokemonClientDelegate self = (PokemonClientDelegate)this;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        PokemonEntity entity = this.currentEntity;
        Optional<String> aspect = entity.getAspects().stream().filter(a -> a.startsWith("msd:tera_")).findFirst();
        if (aspect.isEmpty()) {
            return;
        }
        double distance = player.position().distanceTo(entity.position());
        if (distance > (double)Cobblemon.config.getShinyNoticeParticlesDistance()) {
            return;
        }
        if (this.mega_showdown$secondsSinceLastTeraParticle() > 2.0f) {
            KotlinHelperNeo.INSTANCE.playParticleEffect(TeraHelper.getTeraAnimationFromAspect(aspect.get()), "root", self.getRuntime());
            this.mega_showdown$lastTeraParticle = System.currentTimeMillis();
        }
    }
}

