/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.neoforge.datapack.showdown;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownService;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.utils.datapack.NewAbility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class Abilities
implements DataRegistry {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"mega_showdown/showdown/abilities");
    private static final SimpleObservable<Abilities> OBSERVABLE = new SimpleObservable();
    public static final Abilities INSTANCE = new Abilities();
    private final Map<String, String> abilityScripts = new HashMap<String, String>();

    private Abilities() {
        OBSERVABLE.subscribe(Priority.NORMAL, this::registerAbilities);
    }

    public void registerAbilities(Abilities ability) {
        Cobblemon.INSTANCE.getShowdownThread().queue(showdownService -> {
            if (showdownService instanceof GraalShowdownService) {
                GraalShowdownService service = (GraalShowdownService)showdownService;
                Value receiveAbilityDataFn = service.context.getBindings("js").getMember("receiveAbilityData");
                for (Map.Entry<String, String> entry : INSTANCE.getAbilityScripts().entrySet()) {
                    String abilityId = entry.getKey();
                    String js = entry.getValue().replace("\n", " ");
                    receiveAbilityDataFn.execute(new Object[]{abilityId, js});
                    AbilityTemplate newAbility = NewAbility.INSTANCE.getAbility(abilityId);
                    com.cobblemon.mod.common.api.abilities.Abilities.register((AbilityTemplate)newAbility);
                }
            }
            return Unit.INSTANCE;
        });
    }

    public Map<String, String> getAbilityScripts() {
        return this.abilityScripts;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public PackType getType() {
        return PackType.SERVER_DATA;
    }

    @NotNull
    public SimpleObservable<? extends DataRegistry> getObservable() {
        return OBSERVABLE;
    }

    public void reload(@NotNull ResourceManager resourceManager) {
        this.abilityScripts.clear();
        resourceManager.listResources("mega_showdown/showdown/abilities", path -> path.getPath().endsWith(".js")).forEach((id, resource) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
                String js = reader.lines().collect(Collectors.joining("\n"));
                String abilityId = new File(id.getPath()).getName().replace(".js", "");
                this.abilityScripts.put(abilityId, js);
            }
            catch (IOException e) {
                MegaShowdown.LOGGER.error("Failed to load ability script: {} {}", id, (Object)e);
            }
        });
        OBSERVABLE.emit((Object[])new Abilities[]{this});
    }

    public void sync(@NotNull ServerPlayer serverPlayer) {
    }
}

