/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.mixin.minecraft;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.codec.DuFusion;
import com.github.yajatkaul.mega_showdown.codec.FormChangeInteractItem;
import com.github.yajatkaul.mega_showdown.codec.FormChangeToggleInteractItem;
import com.github.yajatkaul.mega_showdown.codec.SoloFusion;
import com.github.yajatkaul.mega_showdown.utils.RegistryLocator;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"onDestroyed(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="HEAD")})
    private void onDestroyed(ItemEntity itemEntity, CallbackInfo ci) {
        if (!itemEntity.level().isClientSide) {
            SoloFusion soloFusion;
            ItemStack stack = itemEntity.getItem();
            DuFusion duFusion = RegistryLocator.getComponent(DuFusion.class, stack);
            if (duFusion != null) {
                duFusion.onDestroyed(itemEntity);
            }
            if ((soloFusion = RegistryLocator.getComponent(SoloFusion.class, stack)) != null) {
                soloFusion.onDestroyed(itemEntity);
            }
        }
    }

    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void useOnEntity(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!level.isClientSide) {
            SoloFusion soloFusion;
            ItemStack stack = player.getItemInHand(interactionHand);
            DuFusion duFusion = RegistryLocator.getComponent(DuFusion.class, stack);
            if (duFusion != null) {
                cir.setReturnValue(duFusion.use(level, player, interactionHand));
            }
            if ((soloFusion = RegistryLocator.getComponent(SoloFusion.class, stack)) != null) {
                cir.setReturnValue(soloFusion.use(level, player, interactionHand));
            }
        }
    }

    @Inject(method={"interactLivingEntity(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void useOnEntity(Player player, LivingEntity entity, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!player.level().isClientSide && entity instanceof PokemonEntity) {
            FormChangeInteractItem formChangeInteractItem;
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            ItemStack stack = player.getItemInHand(interactionHand);
            FormChangeToggleInteractItem formChangeToggleInteractItem = RegistryLocator.getComponent(FormChangeToggleInteractItem.class, stack);
            if (formChangeToggleInteractItem != null) {
                cir.setReturnValue((Object)formChangeToggleInteractItem.interactLivingEntity(player, (LivingEntity)pokemonEntity, stack));
            }
            if ((formChangeInteractItem = RegistryLocator.getComponent(FormChangeInteractItem.class, stack)) != null) {
                cir.setReturnValue((Object)formChangeInteractItem.interactLivingEntity(player, (LivingEntity)pokemonEntity, stack));
            }
        }
    }
}

