/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.mixin.battle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.github.yajatkaul.mega_showdown.gimmick.GimmickTurnCheck;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShowdownActionRequest.class}, remap=false)
public class ShowdownActionRequestMixin {
    @Shadow
    private List<ShowdownMoveset> active;

    @Inject(method={"sanitize(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;)V"}, at={@At(value="HEAD")}, remap=false)
    private void beforeSanitize(PokemonBattle battle, BattleActor battleActor, CallbackInfo ci) {
        battle.getPlayers().forEach(GimmickTurnCheck::check);
    }

    @Inject(method={"sanitize(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;)V"}, at={@At(value="TAIL")}, remap=false)
    private void afterSanitize(PokemonBattle battle, BattleActor battleActor, CallbackInfo ci) {
        ResourceLocation dynamaxBandId = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"dynamax_band");
        for (ServerPlayer player : battle.getPlayers()) {
            GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            boolean hasBand = data.getKeyItems().contains(dynamaxBandId);
            if (!player.getUUID().equals(battleActor.getUuid())) continue;
            List<ShowdownMoveset> activeMovesets = this.active;
            if (hasBand || activeMovesets == null) continue;
            for (ShowdownMoveset moveset : activeMovesets) {
                moveset.blockGimmick(ShowdownMoveset.Gimmick.DYNAMAX);
                moveset.setMaxMoves(null);
            }
        }
    }
}

