/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.gimmick.codec;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;

public record AspectSetCodec(List<String> required_forms_apply, List<String> blacklisted_forms_revert, List<String> required_forms_revert, List<String> blacklisted_forms_apply, List<List<String>> required_aspects_apply, List<List<String>> blacklist_aspects_apply, List<List<String>> required_aspects_revert, List<List<String>> blacklist_aspects_revert, List<String> apply_aspects, List<String> revert_aspects) {
    public static final Codec<AspectSetCodec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).optionalFieldOf("required_forms_apply", List.of()).forGetter(AspectSetCodec::required_forms_apply), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("blacklisted_forms_revert", List.of()).forGetter(AspectSetCodec::blacklisted_forms_revert), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("required_forms_revert", List.of()).forGetter(AspectSetCodec::required_forms_revert), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("blacklisted_forms_apply", List.of()).forGetter(AspectSetCodec::blacklisted_forms_apply), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("required_aspects_apply", List.of()).forGetter(AspectSetCodec::required_aspects_apply), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("blacklist_aspects_apply", List.of()).forGetter(AspectSetCodec::blacklist_aspects_apply), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("required_aspects_revert", List.of()).forGetter(AspectSetCodec::required_aspects_revert), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("blacklist_aspects_revert", List.of()).forGetter(AspectSetCodec::blacklist_aspects_revert), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("apply_aspects", List.of()).forGetter(AspectSetCodec::apply_aspects), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("revert_aspects", List.of()).forGetter(AspectSetCodec::revert_aspects)).apply((Applicative)instance, AspectSetCodec::new));

    public boolean validate_apply(Pokemon pokemon) {
        if (!this.blacklist_aspects_apply.isEmpty() && this.blacklist_aspects_apply.stream().anyMatch(group -> pokemon.getAspects().containsAll((Collection<?>)group))) {
            return false;
        }
        if (!this.blacklisted_forms_apply.isEmpty() && this.blacklisted_forms_apply.contains(pokemon.getForm().getName())) {
            return false;
        }
        if (!this.required_forms_apply.isEmpty() && !this.required_forms_apply.contains(pokemon.getForm().getName())) {
            return false;
        }
        return this.required_aspects_apply.isEmpty() || this.required_aspects_apply.stream().anyMatch(group -> pokemon.getAspects().containsAll((Collection<?>)group));
    }

    public boolean validate_revert(Pokemon pokemon) {
        if (!this.blacklist_aspects_revert.isEmpty() && this.blacklist_aspects_revert.stream().anyMatch(group -> pokemon.getAspects().containsAll((Collection<?>)group))) {
            return false;
        }
        if (!this.blacklisted_forms_revert.isEmpty() && this.blacklisted_forms_revert.contains(pokemon.getForm().getName())) {
            return false;
        }
        if (!this.required_forms_apply.isEmpty() && !this.required_forms_revert.contains(pokemon.getForm().getName())) {
            return false;
        }
        return this.required_aspects_revert.isEmpty() || this.required_aspects_revert.stream().anyMatch(group -> pokemon.getAspects().containsAll((Collection<?>)group));
    }

    public static AspectSetCodec DEFAULT() {
        return new AspectSetCodec(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
    }
}

