/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.datapack;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.github.yajatkaul.mega_showdown.cobblemon.status.DamageStatus;
import com.github.yajatkaul.mega_showdown.datapack.CustomTypeRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Map;
import kotlin.ranges.IntRange;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.NotNull;

public class CustomTypeStatusRegistry
implements JsonDataRegistry<CustomStatusData> {
    public static final CustomTypeStatusRegistry INSTANCE = new CustomTypeStatusRegistry();
    private final SimpleObservable<CustomTypeStatusRegistry> observable = new SimpleObservable();

    private CustomTypeStatusRegistry() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"mega_showdown/custom_status");
    }

    @NotNull
    public PackType getType() {
        return PackType.SERVER_DATA;
    }

    @NotNull
    public Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    @NotNull
    public TypeToken<CustomStatusData> getTypeToken() {
        return TypeToken.get(CustomStatusData.class);
    }

    @NotNull
    public String getResourcePath() {
        return "mega_showdown/custom_status";
    }

    @NotNull
    public SimpleObservable<CustomTypeStatusRegistry> getObservable() {
        return this.observable;
    }

    public void sync(@NotNull ServerPlayer player) {
    }

    public void reload(@NotNull Map<ResourceLocation, ? extends CustomStatusData> data) {
        data.forEach((identifier, typeData) -> {
            try {
                if (typeData.damageStatusData() != null) {
                    DamageStatus damageStatus = new DamageStatus(MiscUtilsKt.cobblemonResource((String)typeData.name()), typeData.id(), typeData.applyMsg(), typeData.removeMsg(), new IntRange(typeData.minDur(), typeData.maxDur()), typeData.damageStatusData().chance(), typeData.damageStatusData().damagePercent(), typeData.damageStatusData().healingAbility());
                    Statuses.registerStatus((Status)damageStatus);
                } else {
                    PersistentStatus status = new PersistentStatus(MiscUtilsKt.cobblemonResource((String)typeData.name()), typeData.id(), typeData.applyMsg(), typeData.removeMsg(), new IntRange(typeData.minDur(), typeData.maxDur()));
                    Statuses.registerStatus((Status)status);
                }
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Error loading custom statuses {}: {}", identifier, (Object)e.getMessage());
            }
        });
        Cobblemon.LOGGER.info("Loaded {} custom elemental statuses", (Object)CustomTypeRegistry.customTypes.size());
        this.observable.emit((Object[])new CustomTypeStatusRegistry[]{this});
    }

    public record CustomStatusData(String name, String id, String applyMsg, String removeMsg, int minDur, int maxDur, DamageStatusData damageStatusData) {
    }

    public record DamageStatusData(int chance, double damagePercent, String healingAbility) {
    }
}

