/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec.particles;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public record SoundCodec(String id, float vol, float pitch) {
    public static final Codec<SoundCodec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("sound_id").forGetter(SoundCodec::id), (App)Codec.FLOAT.optionalFieldOf("vol", (Object)Float.valueOf(1.0f)).forGetter(SoundCodec::vol), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(SoundCodec::pitch)).apply((Applicative)instance, SoundCodec::new));

    public void play(PokemonEntity context) {
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.tryParse((String)this.id));
        Vec3 entityPos = context.position();
        if (soundEvent == null) {
            MegaShowdown.LOGGER.error("Invalid Sound, sound id: {}", (Object)this.id);
        } else {
            context.level().playSound(null, entityPos.x, entityPos.y, entityPos.z, soundEvent, SoundSource.PLAYERS, this.vol, this.pitch);
        }
    }
}

