/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block.custom;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RotomUnitBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    private static final List<String> rotomAspects = List.of("heat-appliance", "wash-appliance", "mow-appliance", "frost-appliance", "fan-appliance");
    private final String form;

    public RotomUnitBlock(BlockBehaviour.Properties arg, String form) {
        super(arg);
        this.form = form;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext arg) {
        Direction direction = arg.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        PokemonEntity pokemonEntity;
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)entity).getPokemon().getSpecies().getName().equals("Rotom")) {
            if (pokemonEntity.getAspects().stream().noneMatch(rotomAspects::contains)) {
                Effect.getEffect("mega_showdown:rotom_" + this.form + "_effect").applyEffects(pokemonEntity.getPokemon(), List.of(String.format("appliance=%s", this.form)), null);
                level.destroyBlock(pos, false);
                level.levelEvent(2001, pos, Block.getId((BlockState)state));
            }
        }
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9);
    }

    @NotNull
    protected VoxelShape getShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return SHAPE;
    }
}

