/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block.custom;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.block.MegaShowdownBlockEntities;
import com.github.yajatkaul.mega_showdown.block.block_entity.ReassemblyUnitBlockEntity;
import com.github.yajatkaul.mega_showdown.block.custom.HorizontalDirectionalBlock;
import com.github.yajatkaul.mega_showdown.components.InventoryStorage;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.item.MegaShowdownItems;
import com.github.yajatkaul.mega_showdown.item.custom.form_change.ZygardeCube;
import com.mojang.serialization.MapCodec;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ReassemblyUnitBlock
extends BaseEntityBlock {
    public static final EnumProperty<ReassemblyUnitBlockEntity.ReassembleStage> REASSEMBLE_STAGE = EnumProperty.create((String)"reassemble_stage", ReassemblyUnitBlockEntity.ReassembleStage.class);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<ReassemblyUnitBlock> CODEC = ReassemblyUnitBlock.simpleCodec(ReassemblyUnitBlock::new);
    private static final VoxelShape UPPER_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public ReassemblyUnitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassemblyUnitBlockEntity.ReassembleStage.IDLE)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)blockState.getValue(HALF);
        if (direction.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || blockState2.is((Block)this) && blockState2.getValue(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)blockState.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = blockPos.below())).is(blockState.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockpos, blockstate1, 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Direction playerFacing = context.getHorizontalDirection();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)playerFacing.getOpposite());
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, REASSEMBLE_STAGE});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.FAIL;
        }
        pos = blockState.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReassemblyUnitBlockEntity) {
            ReassemblyUnitBlockEntity blockEntity2 = (ReassemblyUnitBlockEntity)blockEntity;
            if (itemStack.getItem() instanceof ZygardeCube) {
                InventoryStorage inventoryStorage = (InventoryStorage)itemStack.getOrDefault(MegaShowdownDataComponents.INVENTORY.get(), (Object)InventoryStorage.defaultStorage(2));
                RegistryAccess registryAccess = level.registryAccess();
                PokemonStorge pokemonStorge = (PokemonStorge)itemStack.getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
                Pokemon storedPokemon = pokemonStorge.getPokemon(registryAccess);
                if (blockEntity2.isIdle()) {
                    if (storedPokemon == null) {
                        SimpleContainer simpleContainer = inventoryStorage.getInventory((HolderLookup.Provider)registryAccess);
                        ItemStack slot0 = simpleContainer.getItem(0);
                        ItemStack slot1 = simpleContainer.getItem(1);
                        if (slot0.getCount() == 95 && slot1.getCount() == 5) {
                            blockEntity2.startProcess(ReassemblyUnitBlockEntity.ReassembleStage.COOKING_100, 12000);
                            simpleContainer.setItem(0, ItemStack.EMPTY);
                            simpleContainer.setItem(1, ItemStack.EMPTY);
                        } else if (slot0.getCount() >= 49 && slot1.getCount() >= 1) {
                            blockEntity2.startProcess(ReassemblyUnitBlockEntity.ReassembleStage.COOKING_50, 6000);
                            slot0.setCount(slot0.getCount() - 49);
                            slot1.setCount(slot1.getCount() - 1);
                            simpleContainer.setItem(0, slot0);
                            simpleContainer.setItem(1, slot1);
                        } else if (slot0.getCount() >= 9 && slot1.getCount() >= 1) {
                            blockEntity2.startProcess(ReassemblyUnitBlockEntity.ReassembleStage.COOKING_10, 2400);
                            slot0.setCount(slot0.getCount() - 9);
                            slot1.setCount(slot1.getCount() - 1);
                            simpleContainer.setItem(0, slot0);
                            simpleContainer.setItem(1, slot1);
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_enough_cells_core").withStyle(ChatFormatting.RED), true);
                            return ItemInteractionResult.FAIL;
                        }
                        itemStack.set(MegaShowdownDataComponents.INVENTORY.get(), (Object)inventoryStorage.save((HolderLookup.Provider)registryAccess, simpleContainer));
                    } else {
                        ItemStack cells = new ItemStack((ItemLike)MegaShowdownItems.ZYGARDE_CELL.get());
                        ItemStack cores = new ItemStack((ItemLike)MegaShowdownItems.ZYGARDE_CORE.get());
                        if (storedPokemon.getAspects().contains("10-percent")) {
                            cells.setCount(9);
                            cores.setCount(1);
                        } else if (storedPokemon.getAspects().contains("50-percent")) {
                            cells.setCount(49);
                            cores.setCount(1);
                        }
                        ItemEntity cellDrop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, cells.copy());
                        level.addFreshEntity((Entity)cellDrop);
                        ItemEntity coreDrop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, cores.copy());
                        level.addFreshEntity((Entity)coreDrop);
                        itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.zygarde_cube.empty"));
                        itemStack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.machine_being_used").withStyle(ChatFormatting.RED), true);
            } else {
                Item inventoryStorage = itemStack.getItem();
                if (inventoryStorage instanceof PokeBallItem) {
                    PokeBallItem pokeBall = (PokeBallItem)inventoryStorage;
                    if (blockEntity2.isFinished()) {
                        int shinyRoll = ThreadLocalRandom.current().nextInt(1, (int)(Cobblemon.config.getShinyRate() + 1.0f));
                        Pokemon zygarde = PokemonProperties.Companion.parse("zygarde").create();
                        zygarde.setCaughtBall(pokeBall.getPokeBall());
                        if (shinyRoll == 1) {
                            zygarde.setShiny(true);
                        }
                        if (blockEntity2.getStage() == ReassemblyUnitBlockEntity.ReassembleStage.FINISHED_10) {
                            new StringSpeciesFeature("percent_cells", "10").apply(zygarde);
                        } else if (blockEntity2.getStage() == ReassemblyUnitBlockEntity.ReassembleStage.FINISHED_50) {
                            new StringSpeciesFeature("percent_cells", "50").apply(zygarde);
                        } else if (blockEntity2.getStage() == ReassemblyUnitBlockEntity.ReassembleStage.FINISHED_100) {
                            new StringSpeciesFeature("percent_cells", "50").apply(zygarde);
                            new FlagSpeciesFeature("power-construct", true).apply(zygarde);
                        }
                        Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player).add(zygarde);
                        itemStack.consume(1, (LivingEntity)player);
                        blockEntity2.setStage(ReassemblyUnitBlockEntity.ReassembleStage.IDLE);
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
        }
        return ItemInteractionResult.FAIL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : ReassemblyUnitBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)MegaShowdownBlockEntities.REASSEMBLY_UNIT_ENTITY.get()), ReassemblyUnitBlockEntity::tick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? new ReassemblyUnitBlockEntity(pos, state) : null;
    }
}

