/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block.custom;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingBlockItem;
import java.util.Objects;
import kotlin.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class PokemonSelectingBlock
extends Block {
    private final ResourceLocation id;
    private final boolean canUseInBattle;

    public PokemonSelectingBlock(BlockBehaviour.Properties properties, ResourceLocation id, boolean canUseInBattle) {
        super(properties);
        this.id = id;
        this.canUseInBattle = canUseInBattle;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (player.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(this.id);
        PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer((ServerPlayer)((ServerPlayer)player));
        if (!this.canUseInBattle && battle != null) {
            return InteractionResult.FAIL;
        }
        if (item instanceof PokemonSelectingBlockItem) {
            PokemonSelectingBlockItem pokemonSelectingItem = (PokemonSelectingBlockItem)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PartySelectCallbacks.INSTANCE.createFromPokemon(serverPlayer, PlayerExtensionsKt.party((ServerPlayer)serverPlayer).toGappyList().stream().filter(Objects::nonNull).toList(), pokemon -> pokemonSelectingItem.canUseOnPokemon(pokemonSelectingItem.getDefaultInstance(), (Pokemon)pokemon), pokemon -> {
                    pokemonSelectingItem.applyToPokemon(serverPlayer, pokemonSelectingItem.getDefaultInstance(), (Pokemon)pokemon);
                    return Unit.INSTANCE;
                });
            }
        }
        return InteractionResult.SUCCESS;
    }
}

