/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.prizowo.enchantmentlevelbreak.config.Config;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Unique
    private static final ThreadLocal<Boolean> IS_PROCESSING = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"enchant"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEnchant(Holder<Enchantment> enchantment, int level, CallbackInfo ci) {
        if (IS_PROCESSING.get().booleanValue()) {
            return;
        }
        try {
            IS_PROCESSING.set(true);
            ItemStack stack = (ItemStack)this;
            if (!stack.isEmpty() && level > 0) {
                level = Math.min(level, Config.maxEnchantmentLevel);
                if (stack.is(Items.ENCHANTED_BOOK)) {
                    ItemEnchantments currentEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                    ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(currentEnchantments);
                    mutable.set(enchantment, level);
                    stack.set(DataComponents.STORED_ENCHANTMENTS, (Object)mutable.toImmutable());
                } else {
                    ItemEnchantments currentEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                    ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(currentEnchantments);
                    mutable.set(enchantment, level);
                    stack.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
                }
                ci.cancel();
            }
        }
        finally {
            IS_PROCESSING.set(false);
        }
    }

    @Inject(method={"isEnchantable"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsEnchantable(CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = (ItemStack)this;
        cir.setReturnValue((Object)(!stack.isEmpty() && stack.getCount() == 1 ? 1 : 0));
    }
}

