/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.server.commands.EnchantCommand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantCommand.class})
public class Command {
    @Inject(method={"enchant"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onEnchant(CommandSourceStack source, Collection<? extends Entity> targets, Holder<Enchantment> enchantment, int level, CallbackInfoReturnable<Integer> cir) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            LivingEntity livingEntity;
            ItemStack itemStack;
            if (!(entity instanceof LivingEntity) || (itemStack = (livingEntity = (LivingEntity)entity).getMainHandItem()).isEmpty()) continue;
            itemStack.enchant(enchantment, level);
            ++i;
        }
        cir.setReturnValue((Object)i);
        cir.cancel();
    }
}

