/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class CEnchantCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ENCHANTMENTS = (context, builder) -> SharedSuggestionProvider.suggestResource((Iterable)((CommandSourceStack)context.getSource()).registryAccess().registryOrThrow(Registries.ENCHANTMENT).keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cenchant").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"enchantment", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_ENCHANTMENTS).executes(context -> CEnchantCommand.enchantItem((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"enchantment"), 1))).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CEnchantCommand.enchantItem((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))));
    }

    private static int enchantItem(CommandSourceStack source, String enchantmentInput, int level) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"You must be holding an item to enchant"));
            return 0;
        }
        String[] parts = enchantmentInput.split("\\s+", 2);
        String enchantmentName = parts[0];
        if (parts.length > 1) {
            try {
                level = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ResourceLocation enchantmentId = !enchantmentName.contains(":") ? ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)enchantmentName) : ResourceLocation.parse((String)enchantmentName);
        Holder enchantment = source.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(enchantmentId).orElse(null);
        if (enchantment == null) {
            source.sendFailure((Component)Component.literal((String)("Invalid enchantment: " + enchantmentName)));
            return 0;
        }
        ItemEnchantments currentEnchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(currentEnchantments);
        mutable.set(enchantment, level);
        itemStack.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
        int finalLevel = level;
        source.sendSuccess(() -> Component.literal((String)("Applied " + Enchantment.getFullname((Holder)enchantment, (int)finalLevel).getString() + " to the item")), true);
        return 1;
    }
}

