/*
 * Decompiled with CFR 0.152.
 */
package chadlymasterson.safepastures;

import chadlymasterson.safepastures.SafePastures;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.fml.loading.FMLPaths;

public class ConfigLoader {
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("safepastures");
    private static File CONFIG_FILE;
    public boolean preventPokemonDamageInPasture = true;
    public boolean useBlackList = false;
    public Map<String, Boolean> damageSourceBlackList = new HashMap<String, Boolean>();
    public static final Gson GSON;

    public ConfigLoader(String filename, ServerLevel serverWorld) {
        CONFIG_FILE = new File(String.valueOf(CONFIG_PATH), filename);
        this.populateDefaultDamageSources(serverWorld);
        this.load();
    }

    public void load() {
        if (!CONFIG_FILE.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            ConfigLoader loaded = (ConfigLoader)GSON.fromJson((Reader)reader, ConfigLoader.class);
            this.preventPokemonDamageInPasture = loaded.preventPokemonDamageInPasture;
            this.useBlackList = loaded.useBlackList;
            this.damageSourceBlackList = loaded.damageSourceBlackList;
        }
        catch (IOException e) {
            SafePastures.LOGGER.error("Failed to load config: " + e.getMessage());
        }
    }

    public void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            SafePastures.LOGGER.error("Failed to save config: " + e.getMessage());
        }
    }

    public void populateDefaultDamageSources(ServerLevel serverWorld) {
        Registry damageTypeRegistry = (Registry)serverWorld.registryAccess().registry(Registries.DAMAGE_TYPE).orElseThrow(() -> new RuntimeException("DamageType registry not found."));
        for (ResourceLocation id : damageTypeRegistry.keySet()) {
            this.damageSourceBlackList.putIfAbsent(id.getPath(), false);
        }
    }

    public String toJsonString() {
        return GSON.toJson((Object)this);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    }
}

