/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.util.Mth;

public enum Priority {
    LOWEST,
    LOW,
    NORMAL,
    HIGH,
    HIGHEST;

    public static final Priority[] VALUES;

    public Priority add(Priority other) {
        if (this == NORMAL) {
            return other;
        }
        if (other == NORMAL) {
            return this;
        }
        return Priority.fromSorting(this.getSorting() + other.getSorting());
    }

    public int getSorting() {
        return this.ordinal() - 2;
    }

    public static Priority fromSorting(int sorting) {
        return Priority.values()[Mth.clamp((int)(sorting + 2), (int)0, (int)(Priority.values().length - 1))];
    }

    static {
        VALUES = Priority.values();
    }

    public static interface IPriority {
        public static final Function<Object, Priority> GETTER = IPriority::get;

        public Priority getPriority();

        public static <T> Comparator<T> compare() {
            return Comparator.comparing(GETTER);
        }

        public static Priority get(Object o) {
            if (o instanceof IPriority) {
                IPriority p = (IPriority)o;
                return p.getPriority();
            }
            return NORMAL;
        }
    }
}

