/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemore_lib.items.sword;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SwordItemTier
extends SwordItem {
    public SwordItemTier(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cobblemore_lib.custom_sword"));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, level, entity, slot, selected);
        if (stack.getItem() instanceof SwordItemTier && stack.getEnchantments().isEmpty()) {
            Registry enchantmentRegistry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            Optional unbreaking = enchantmentRegistry.getHolder(ResourceLocation.tryParse((String)"minecraft:unbreaking"));
            Optional sharpness = enchantmentRegistry.getHolder(ResourceLocation.tryParse((String)"minecraft:sharpness"));
            unbreaking.ifPresent(e -> {
                stack.enchant((Holder)e, 2);
                System.out.println("Aplicando encantamento de quebra: " + String.valueOf(e));
            });
            sharpness.ifPresent(e -> {
                stack.enchant((Holder)e, 2);
                System.out.println("Aplicando encantamento de afia\u00e7\u00e3o: " + String.valueOf(e));
            });
        }
    }
}

