/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemore_lib.items.armor.water_stone;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class WaterStoneArmorItem
extends ArmorItem {
    public WaterStoneArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cobblemore_lib.water_stone_armor"));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        boolean fullSet;
        super.inventoryTick(stack, level, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack boots = (ItemStack)player.getInventory().armor.get(0);
        ItemStack legs = (ItemStack)player.getInventory().armor.get(1);
        ItemStack chest = (ItemStack)player.getInventory().armor.get(2);
        ItemStack head = (ItemStack)player.getInventory().armor.get(3);
        boolean bl = fullSet = this.isWaterStoneArmor(boots) && this.isWaterStoneArmor(legs) && this.isWaterStoneArmor(chest) && this.isWaterStoneArmor(head);
        if (fullSet && !stack.isEnchanted()) {
            Registry enchantmentRegistry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            Optional featherFalling = enchantmentRegistry.getHolder(ResourceLocation.withDefaultNamespace((String)"fire_protection"));
            Optional thorns = enchantmentRegistry.getHolder(ResourceLocation.withDefaultNamespace((String)"unbreaking"));
            featherFalling.ifPresent(e -> stack.enchant((Holder)e, 4));
            thorns.ifPresent(e -> stack.enchant((Holder)e, 4));
        }
    }

    private boolean isWaterStoneArmor(ItemStack stack) {
        return stack.getItem() instanceof WaterStoneArmorItem;
    }
}

