/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureCardDefinitionManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Mob Capture Card Definition Manager]";
    private static final Map<ResourceLocation, MobCaptureCardDefinition> DEFINITIONS = new ConcurrentHashMap<ResourceLocation, MobCaptureCardDefinition>();
    private static final Map<EntityType<?>, MobCaptureCardDefinition> ENTITY_TYPE_DEFINITIONS = new ConcurrentHashMap();

    private MobCaptureCardDefinitionManager() {
    }

    public static void setDefinitions(Map<ResourceLocation, MobCaptureCardDefinition> definitions) {
        log.debug("{} Set {} definitions with {}", (Object)LOG_PREFIX, (Object)definitions.size(), definitions.keySet());
        DEFINITIONS.clear();
        ENTITY_TYPE_DEFINITIONS.clear();
        for (Map.Entry<ResourceLocation, MobCaptureCardDefinition> entry : definitions.entrySet()) {
            MobCaptureCardDefinitionManager.addDefinition(entry.getKey(), entry.getValue());
        }
    }

    public static void addDefinition(ResourceLocation entity, MobCaptureCardDefinition definition) {
        Optional entityType = BuiltInRegistries.ENTITY_TYPE.getOptional(definition.entity());
        if (entityType.isEmpty()) {
            log.warn("{} Skipping {} definition {}. Entity type {} not found.", (Object)LOG_PREFIX, (Object)entity, (Object)definition, (Object)definition.entity());
            log.warn("This is expected for custom and mod entities which are not loaded.");
            return;
        }
        log.debug("{} Add {} definition: {}", (Object)LOG_PREFIX, (Object)entity, (Object)definition);
        MobCaptureCardDefinition mobCaptureCardDefinition = definition.withEntityType((EntityType)entityType.get());
        DEFINITIONS.put(entity, mobCaptureCardDefinition);
        ENTITY_TYPE_DEFINITIONS.put((EntityType)entityType.get(), mobCaptureCardDefinition);
    }

    public static MobCaptureCardDefinition get(ResourceLocation entity) {
        return DEFINITIONS.get(entity);
    }

    public static MobCaptureCardDefinition get(EntityType<?> entityType) {
        return ENTITY_TYPE_DEFINITIONS.get(entityType);
    }

    public static boolean has(ResourceLocation entity) {
        return DEFINITIONS.containsKey(entity);
    }

    public static Set<ResourceLocation> getDefinedEntities() {
        return DEFINITIONS.keySet();
    }

    public static Map<ResourceLocation, MobCaptureCardDefinition> getAll() {
        return Collections.unmodifiableMap(DEFINITIONS);
    }

    public static void clear() {
        log.debug("{} Clear {} definitions ...", (Object)LOG_PREFIX, (Object)DEFINITIONS.size());
        DEFINITIONS.clear();
    }
}

