/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.model;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ModelManagerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    public static final Set<String> KNOWN_MISSING_MODELS = new HashSet<String>();
    public static final String LOG_PREFIX = "[Model Manager]";
    public static final String MODEL_SEARCH_PATH = "easy_mob_farm/mob_capture_card/";
    public static final ModelResourceLocation DEFAULT_MODEL = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default"), "standalone");
    public static final ModelResourceLocation DEFAULT_UNCOMMON_MODEL = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default_uncommon"), "standalone");
    public static final ModelResourceLocation DEFAULT_RARE_MODEL = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default_rare"), "standalone");
    public static final ModelResourceLocation DEFAULT_EPIC_MODEL = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default_epic"), "standalone");
    public static final ModelResourceLocation DEFAULT_FISH_MODEL = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default_fish"), "standalone");

    private static boolean isFish(EntityType<?> entityType) {
        ResourceLocation entityId = EntityType.getKey(entityType);
        Item correspondingItem = (Item)BuiltInRegistries.ITEM.get(entityId);
        return correspondingItem != Items.AIR && correspondingItem.builtInRegistryHolder().is(ItemTags.FISHES);
    }

    public static ModelResourceLocation getModelResourceLocation(ResourceLocation resourceLocation) {
        return new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)resourceLocation.getPath().replaceFirst("^models/", "").replaceFirst("\\.json$", "")), "standalone");
    }

    public static boolean isMobCaptureCardModel(ResourceLocation resourceLocation) {
        return resourceLocation != null && resourceLocation.getPath().contains(MODEL_SEARCH_PATH);
    }

    default public BakedModel getModel(ModelResourceLocation modelResourceLocation) {
        if (modelResourceLocation == null) {
            return null;
        }
        BakedModel bakedModel = Minecraft.getInstance().getModelManager().getModel(modelResourceLocation);
        if (bakedModel == Minecraft.getInstance().getModelManager().getMissingModel()) {
            if (KNOWN_MISSING_MODELS.add(modelResourceLocation.toString())) {
                log.error("{} Missing model for '{}'", (Object)LOG_PREFIX, (Object)modelResourceLocation);
            }
            return null;
        }
        return bakedModel != Minecraft.getInstance().getModelManager().getMissingModel() ? bakedModel : null;
    }

    default public BakedModel getModel(String type, String variant, MobColor color) {
        BakedModel bakedModel;
        MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(ResourceLocation.parse((String)type));
        if (mobCaptureCardDefinition == null) {
            return null;
        }
        ModelResourceLocation modelResourceLocation = null;
        if (variant != null && !variant.isBlank() && color != null && color != MobColor.NONE) {
            if (mobCaptureCardDefinition.variants().containsKey(variant) && mobCaptureCardDefinition.variants().get(variant).colors().containsKey((Object)color)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.variants().get(variant).colors().get((Object)color).model());
            }
        } else if (variant != null && !variant.isBlank()) {
            if (mobCaptureCardDefinition.variants().containsKey(variant)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.variants().get(variant).model());
            }
        } else if (color != null && color != MobColor.NONE) {
            String colorName = color.getName().toLowerCase(Locale.ROOT);
            if (mobCaptureCardDefinition.colors().containsKey(colorName)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.colors().get(colorName).model());
            }
        }
        ModelResourceLocation defaultModelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.model());
        if (modelResourceLocation == null) {
            modelResourceLocation = defaultModelResourceLocation;
        }
        if ((bakedModel = this.getModel(modelResourceLocation)) == Minecraft.getInstance().getModelManager().getMissingModel()) {
            bakedModel = Minecraft.getInstance().getModelManager().getModel(defaultModelResourceLocation);
        }
        return bakedModel;
    }

    default public BakedModel getModel(String type) {
        return this.getModel(type, null, null);
    }

    default public BakedModel getModel(Rarity rarity) {
        if (rarity == null) {
            return null;
        }
        ModelResourceLocation modelResourceLocation = switch (rarity) {
            default -> throw new MatchException(null, null);
            case Rarity.COMMON -> DEFAULT_MODEL;
            case Rarity.UNCOMMON -> DEFAULT_UNCOMMON_MODEL;
            case Rarity.RARE -> DEFAULT_RARE_MODEL;
            case Rarity.EPIC -> DEFAULT_EPIC_MODEL;
        };
        return this.getModel(modelResourceLocation);
    }

    default public BakedModel getModel(EntityType<?> entityType) {
        if (entityType == null || !ModelManagerInterface.isFish(entityType)) {
            return null;
        }
        return this.getModel(DEFAULT_FISH_MODEL);
    }

    default public BakedModel getDefaultModel() {
        return this.getModel(DEFAULT_MODEL);
    }
}

