/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.pokebike.recipe;

import com.levelscraft7.pokebike.PokeBike;
import com.levelscraft7.pokebike.item.PokeBikeItems;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public final class PokeBikeRecipes {
    private PokeBikeRecipes() {
    }

    public static void register() {
        LifecycleEvent.SERVER_STARTED.register(server -> PokeBikeRecipes.injectRecipes(server.getRecipeManager()));
    }

    private static void injectRecipes(RecipeManager recipeManager) {
        ArrayList<RecipeHolder<ShapedRecipe>> recipes = new ArrayList<RecipeHolder<ShapedRecipe>>(recipeManager.getRecipes());
        recipes.add(PokeBikeRecipes.buildBikeRecipe("red_bike", Items.RED_WOOL, (Item)PokeBikeItems.RED_BIKE.get()));
        recipes.add(PokeBikeRecipes.buildBikeRecipe("blue_bike", Items.BLUE_WOOL, (Item)PokeBikeItems.BLUE_BIKE.get()));
        recipes.add(PokeBikeRecipes.buildBikeRecipe("green_bike", Items.GREEN_WOOL, (Item)PokeBikeItems.GREEN_BIKE.get()));
        recipes.add(PokeBikeRecipes.buildBikeRecipe("yellow_bike", Items.YELLOW_WOOL, (Item)PokeBikeItems.YELLOW_BIKE.get()));
        recipes.add(PokeBikeRecipes.buildWrenchRecipe());
        recipeManager.replaceRecipes(recipes);
    }

    private static RecipeHolder<ShapedRecipe> buildBikeRecipe(String id, Item wool, Item result) {
        Map<Character, Ingredient> key = Map.of(Character.valueOf('I'), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), Character.valueOf('S'), Ingredient.of((ItemLike[])new ItemLike[]{Items.SADDLE}), Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLACK_DYE}), Character.valueOf('R'), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_BLOCK}), Character.valueOf('W'), Ingredient.of((ItemLike[])new ItemLike[]{wool}));
        ShapedRecipePattern pattern = ShapedRecipePattern.of(key, (String[])new String[]{"ISI", "IWI", "BRB"});
        ResourceLocation recipeId = PokeBike.id(id);
        ShapedRecipe recipe = new ShapedRecipe("", CraftingBookCategory.MISC, pattern, new ItemStack((ItemLike)result));
        return new RecipeHolder(recipeId, (Recipe)recipe);
    }

    private static RecipeHolder<ShapedRecipe> buildWrenchRecipe() {
        Map<Character, Ingredient> key = Map.of(Character.valueOf('I'), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), Character.valueOf('S'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}));
        ShapedRecipePattern pattern = ShapedRecipePattern.of(key, (String[])new String[]{" I ", " SI", "S  "});
        ResourceLocation recipeId = PokeBike.id("wrench");
        ShapedRecipe recipe = new ShapedRecipe("", CraftingBookCategory.MISC, pattern, new ItemStack((ItemLike)PokeBikeItems.WRENCH.get()));
        return new RecipeHolder(recipeId, (Recipe)recipe);
    }
}

