/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.pokebike.network;

import com.levelscraft7.pokebike.entity.BikeEntity;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class PokeBikeNetwork {
    public static final CustomPacketPayload.Type<BikeInputPayload> BIKE_INPUT_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pokebike", (String)"bike_input"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BikeInputPayload> BIKE_INPUT_CODEC = new StreamCodec<RegistryFriendlyByteBuf, BikeInputPayload>(){

        public BikeInputPayload decode(RegistryFriendlyByteBuf buf) {
            int entityId = buf.readVarInt();
            float strafe = buf.readFloat();
            float forward = buf.readFloat();
            float yaw = buf.readFloat();
            return new BikeInputPayload(entityId, strafe, forward, yaw);
        }

        public void encode(RegistryFriendlyByteBuf buf, BikeInputPayload payload) {
            buf.writeVarInt(payload.entityId());
            buf.writeFloat(payload.strafe());
            buf.writeFloat(payload.forward());
            buf.writeFloat(payload.yaw());
        }
    };

    private PokeBikeNetwork() {
    }

    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, BIKE_INPUT_TYPE, BIKE_INPUT_CODEC, (payload, context) -> context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            Entity e = sp.level().getEntity(payload.entityId());
            if (e instanceof BikeEntity) {
                BikeEntity bike = (BikeEntity)e;
                if (bike.getControllingPassenger() != sp) {
                    return;
                }
                if (sp.getVehicle() != bike) {
                    return;
                }
                float strafe = Mth.clamp((float)payload.strafe(), (float)-1.0f, (float)1.0f);
                float forward = Mth.clamp((float)payload.forward(), (float)-1.0f, (float)1.0f);
                float yaw = payload.yaw();
                bike.setServerInput(strafe, forward, yaw);
            }
        }));
    }

    public static void sendBikeInput(int entityId, float strafe, float forward, float yaw) {
        NetworkManager.sendToServer((CustomPacketPayload)new BikeInputPayload(entityId, strafe, forward, yaw));
    }

    public record BikeInputPayload(int entityId, float strafe, float forward, float yaw) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return BIKE_INPUT_TYPE;
        }
    }
}

