/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.pokebike.item;

import com.levelscraft7.pokebike.client.render.YellowBikeItemRenderer;
import com.levelscraft7.pokebike.entity.BikeEntity;
import com.levelscraft7.pokebike.entity.BikeSpawner;
import com.levelscraft7.pokebike.entity.PokeBikeEntities;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public final class YellowBikeItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public YellowBikeItem(Item.Properties properties) {
        super(properties);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private YellowBikeItemRenderer renderer;

            @Nullable
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new YellowBikeItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.getAbilities().mayBuild || player.isSpectator()) {
            return super.use(level, player, hand);
        }
        BlockHitResult hitResult = YellowBikeItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        BlockHitResult blockHit = hitResult;
        BlockPos spawnPos = blockHit.getBlockPos().relative(blockHit.getDirection());
        InteractionResult result = BikeSpawner.spawnBike((EntityType<? extends BikeEntity>)((EntityType)PokeBikeEntities.YELLOW_BIKE.get()), level, spawnPos, player.getYRot(), (LivingEntity)player);
        if (result.consumesAction() && !level.isClientSide && !player.getAbilities().instabuild) {
            player.getItemInHand(hand).shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        BlockPos spawnPos = context.getClickedPos().relative(context.getClickedFace());
        InteractionResult result = BikeSpawner.spawnBike((EntityType<? extends BikeEntity>)((EntityType)PokeBikeEntities.YELLOW_BIKE.get()), level, spawnPos, context.getPlayer().getYRot(), (LivingEntity)context.getPlayer());
        if (result.consumesAction() && !level.isClientSide && !context.getPlayer().getAbilities().instabuild) {
            context.getItemInHand().shrink(1);
        }
        return level.isClientSide ? InteractionResult.SUCCESS : result;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.pokebike.bike").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.pokebike.bike.wrench").withStyle(ChatFormatting.GRAY));
    }
}

