/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.pokebike.entity;

import com.levelscraft7.pokebike.config.PokeBikeConfig;
import com.levelscraft7.pokebike.entity.BikeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class BikeSpawner {
    private static final double SPAWN_OFFSET = 0.01;

    private BikeSpawner() {
    }

    public static InteractionResult spawnBike(EntityType<? extends BikeEntity> bikeType, Level level, BlockPos pos, float yaw, LivingEntity placer) {
        BikeEntity bike = (BikeEntity)bikeType.create(level);
        if (bike == null) {
            return InteractionResult.FAIL;
        }
        Vec3 spawnLocation = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.01, 0.0);
        bike.moveTo(spawnLocation.x, spawnLocation.y, spawnLocation.z, yaw, 0.0f);
        if (!level.noCollision((Entity)bike)) {
            return InteractionResult.FAIL;
        }
        level.addFreshEntity((Entity)bike);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            if (PokeBikeConfig.get().bikeOwnershipEnabled) {
                bike.assignOwner(player);
            }
            player.startRiding((Entity)bike, true);
        }
        return InteractionResult.CONSUME;
    }
}

