/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.pokebike.entity;

import com.levelscraft7.pokebike.PokeBike;
import com.levelscraft7.pokebike.config.PokeBikeConfig;
import com.levelscraft7.pokebike.item.PokeBikeItems;
import com.levelscraft7.pokebike.network.PokeBikeNetwork;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BikeEntity
extends Entity
implements GeoEntity {
    private static final String OWNER_TAG = "Owner";
    private static final int OWNERSHIP_DENY_STAY_TICKS = 80;
    private static final int OWNERSHIP_DENY_FADE_OUT_TICKS = 20;
    private int dismountFreezeTicks = 0;
    private Vec3 committedPos = Vec3.ZERO;
    private Vec3 committedVel = Vec3.ZERO;
    private static final float PASSENGER_OFFSET = -0.4f;
    private static final double MOVE_SPEED = 0.7;
    private static final float STEP_HEIGHT = 1.0f;
    private static final float FALL_DAMAGE_REDUCTION = 0.25f;
    private static final int LIQUID_MESSAGE_COOLDOWN_TICKS = 100;
    private float animSpeedSmoothed = 1.0f;
    private int animStopDelayTicks = 0;
    private float serverStrafe;
    private float serverForward;
    private float serverYaw;
    private static final Vector3f DECELERATION = new Vector3f(0.65f, 1.0f, 0.65f);
    private static final float PASSENGER_ROTATION_LERP_STEP = 40.0f;
    private static final float PASSENGER_MIN_ROTATION_LERP_STEP = 8.0f;
    private static final float VELOCITY_ROTATION_LERP_STEP = 8.0f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean hasMovementInput;
    private static final EntityDataAccessor<Boolean> DATA_MOVEMENT_INPUT = SynchedEntityData.defineId(BikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean wasInWater;
    private boolean wasInLava;
    private int liquidMessageCooldownTicks;
    private UUID owner;
    private boolean ownerInvalid;
    private static final RawAnimation BIKE_LOOP = RawAnimation.begin().thenLoop("animation");

    private void storeServerStateNow() {
        this.committedPos = this.position();
        this.committedVel = this.getDeltaMovement();
    }

    private void commitServerStateForDismount() {
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.committedPos = this.position();
        this.committedVel = this.getDeltaMovement();
    }

    private void syncServerStateToTrackersNow() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.getChunkSource().broadcast((Entity)this, (Packet)new ClientboundTeleportEntityPacket((Entity)this));
        serverLevel.getChunkSource().broadcast((Entity)this, (Packet)new ClientboundSetEntityMotionPacket((Entity)this));
    }

    private void requestOneTickFreezeAfterDismount() {
        this.dismountFreezeTicks = 1;
    }

    public BikeEntity(EntityType<? extends BikeEntity> type, Level level) {
        super(type, level);
    }

    public ResourceLocation getBikeTexture() {
        return PokeBike.id("textures/entity/red_bike.png");
    }

    public Item getBikeItem() {
        return (Item)PokeBikeItems.RED_BIKE.get();
    }

    public float maxUpStep() {
        return 1.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_MOVEMENT_INPUT, (Object)false);
    }

    public void setServerInput(float strafe, float forward, float yaw) {
        this.serverStrafe = strafe;
        this.serverForward = forward;
        this.serverYaw = yaw;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.owner != null) {
            tag.putUUID(OWNER_TAG, this.owner);
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.owner = null;
        this.ownerInvalid = false;
        if (tag.contains(OWNER_TAG)) {
            if (tag.hasUUID(OWNER_TAG)) {
                this.owner = tag.getUUID(OWNER_TAG);
            } else {
                this.ownerInvalid = true;
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.liquidMessageCooldownTicks > 0) {
                --this.liquidMessageCooldownTicks;
            }
            if (this.dismountFreezeTicks > 0) {
                --this.dismountFreezeTicks;
                this.storeServerStateNow();
                return;
            }
            this.handlePassengerInput(true, true);
            this.applyGravity();
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyFriction();
            this.handleLiquidContact();
            if (this.isInLava() && !this.isRemoved()) {
                this.destroyInLava();
                return;
            }
        } else {
            boolean predict = this.isControlledByLocalInstance();
            this.handlePassengerInput(predict, false);
            if (predict) {
                this.applyGravity();
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.applyFriction();
                this.storeServerStateNow();
            }
        }
        this.updateOrientation();
    }

    protected void removePassenger(Entity passenger) {
        if (!this.level().isClientSide) {
            this.commitServerStateForDismount();
            this.requestOneTickFreezeAfterDismount();
        }
        super.removePassenger(passenger);
        if (!this.level().isClientSide) {
            this.commitServerStateForDismount();
            this.syncServerStateToTrackersNow();
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.is(DamageTypes.LAVA)) {
            return false;
        }
        return !source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide && !this.isRemoved()) {
            if (source.is(DamageTypes.LAVA)) {
                this.destroyInLava();
                return true;
            }
            if (source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
                this.discard();
                return true;
            }
        }
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    protected void positionRider(Entity rider, Entity.MoveFunction callback) {
        if (rider instanceof Player) {
            double riderOffset = this.getPassengerAttachmentOffset(rider);
            Vec3 attachment = new Vec3(0.0, riderOffset, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180));
            callback.accept(rider, this.getX() + attachment.x, this.getY() + attachment.y, this.getZ() + attachment.z);
            if (rider instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)rider;
                float headYaw = living.getYHeadRot();
                living.setYBodyRot(headYaw);
                living.yBodyRotO = headYaw;
            }
        } else {
            super.positionRider(rider, callback);
        }
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().isEmpty() && passenger instanceof Player && !this.isTouchingLiquid();
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity living;
        Entity passenger = this.getFirstPassenger();
        return passenger instanceof LivingEntity ? (living = (LivingEntity)passenger) : null;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        boolean shouldPickup;
        ItemStack heldItem = player.getItemInHand(hand);
        PokeBikeConfig config = PokeBikeConfig.get();
        boolean isWrench = heldItem.is((Item)PokeBikeItems.WRENCH.get());
        boolean isEmptyHand = heldItem.isEmpty();
        boolean isShiftPickup = player.isShiftKeyDown() && isEmptyHand;
        boolean bl = shouldPickup = config.requireWrenchToPickupBike ? isWrench : isShiftPickup;
        if (shouldPickup) {
            if (config.bikeOwnershipEnabled && !player.hasPermissions(2)) {
                if (this.ownerInvalid) {
                    this.sendOwnershipDenied(player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                this.assignOwnerIfMissing(player);
                if (this.owner != null && !this.owner.equals(player.getUUID())) {
                    this.sendOwnershipDenied(player);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
            if (this.isPickupBlockedByRider()) {
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.level().isClientSide && !this.isRemoved()) {
                this.ejectPassengers();
                ItemStack bikeStack = new ItemStack((ItemLike)this.getBikeItem());
                if (!player.addItem(bikeStack)) {
                    player.drop(bikeStack, false);
                }
                this.discard();
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.getControllingPassenger() == null && !this.level().isClientSide) {
            this.assignOwnerIfMissing(player);
            if (this.isTouchingLiquid()) {
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            player.startRiding((Entity)this);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    private boolean isPickupBlockedByRider() {
        if (this.level().isClientSide) {
            return false;
        }
        AABB searchBox = new AABB(-3.0E7, (double)this.level().getMinBuildHeight(), -3.0E7, 3.0E7, (double)this.level().getMaxBuildHeight(), 3.0E7);
        return !this.level().getEntitiesOfClass(BikeEntity.class, searchBox, BikeEntity::hasPlayerPassenger).isEmpty();
    }

    private static boolean hasPlayerPassenger(BikeEntity bike) {
        return bike.getPassengers().stream().anyMatch(passenger -> passenger instanceof Player);
    }

    void assignOwner(Player player) {
        if (!this.level().isClientSide && player != null) {
            this.owner = player.getUUID();
            this.ownerInvalid = false;
        }
    }

    private void assignOwnerIfMissing(Player player) {
        if (!this.level().isClientSide) {
            PokeBikeConfig config = PokeBikeConfig.get();
            if (config.bikeOwnershipEnabled && this.owner == null && !this.ownerInvalid) {
                this.assignOwner(player);
            }
        }
    }

    private void sendOwnershipDenied(Player player) {
        if (this.level().isClientSide) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetTitlesAnimationPacket(0, 80, 20));
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.pokebike.ownership.pickup_denied")));
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        BlockPos basePos = this.blockPosition();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Vec3 candidate = DismountHelper.findSafeDismountLocation((EntityType)passenger.getType(), (CollisionGetter)this.level(), (BlockPos)basePos.relative(direction), (boolean)false);
            if (candidate == null) continue;
            return candidate;
        }
        Vec3 fallback = DismountHelper.findSafeDismountLocation((EntityType)passenger.getType(), (CollisionGetter)this.level(), (BlockPos)basePos, (boolean)false);
        return fallback != null ? fallback : super.getDismountLocationForPassenger(passenger);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movement", 0, state -> {
            if (!this.isVehicle() || this.getControllingPassenger() == null) {
                this.animSpeedSmoothed = 0.0f;
                this.animStopDelayTicks = 0;
                return PlayState.STOP;
            }
            double speed = this.getDeltaMovement().horizontalDistance();
            double stopThreshold = 0.0025;
            double baseSpeed = 0.1;
            float target = (float)(speed / baseSpeed);
            target = Mth.clamp((float)target, (float)0.0f, (float)3.0f);
            float smoothing = 0.18f;
            this.animSpeedSmoothed = Mth.lerp((float)smoothing, (float)this.animSpeedSmoothed, (float)target);
            this.animStopDelayTicks = speed < stopThreshold ? ++this.animStopDelayTicks : 0;
            if (this.animStopDelayTicks > 8 && this.animSpeedSmoothed < 0.08f) {
                this.animSpeedSmoothed = 0.0f;
                return PlayState.STOP;
            }
            state.getController().setAnimationSpeed((double)Math.max(0.08f, this.animSpeedSmoothed));
            state.setAndContinue(BIKE_LOOP);
            return PlayState.CONTINUE;
        }));
    }

    public double getTick(Object o) {
        return this.tickCount;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void destroyInLava() {
        this.discard();
    }

    private void handlePassengerInput(boolean applyMovement, boolean syncToClients) {
        float yaw;
        float forward;
        float strafe;
        LivingEntity passenger = this.getControllingPassenger();
        if (passenger == null) {
            this.hasMovementInput = false;
            if (syncToClients) {
                this.entityData.set(DATA_MOVEMENT_INPUT, (Object)false);
            }
            return;
        }
        if (this.level().isClientSide && this.isControlledByLocalInstance()) {
            strafe = passenger.xxa;
            forward = passenger.zza;
            yaw = passenger.getYRot();
            if (applyMovement) {
                PokeBikeNetwork.sendBikeInput(this.getId(), strafe, forward, yaw);
            }
        } else if (!this.level().isClientSide) {
            strafe = this.serverStrafe;
            forward = this.serverForward;
            this.serverYaw = yaw = passenger.getYRot();
        } else {
            strafe = this.serverStrafe;
            forward = this.serverForward;
            yaw = this.serverYaw;
        }
        if (this.level().isClientSide) {
            this.updateRotationFromPassenger(passenger);
        } else {
            this.setYRot(yaw);
            this.yRotO = yaw;
            this.setYHeadRot(yaw);
        }
        Vec3 input = new Vec3((double)strafe, 0.0, (double)forward);
        boolean bl = this.hasMovementInput = input.lengthSqr() > 1.0E-6;
        if (syncToClients) {
            this.entityData.set(DATA_MOVEMENT_INPUT, (Object)this.hasMovementInput);
        }
        if (applyMovement) {
            double speedMultiplier = PokeBikeConfig.get().bikeSpeedMultiplier;
            Vec3 desiredHorizontal = this.hasMovementInput ? input.normalize().scale(0.7 * speedMultiplier).yRot(-this.getYRot() * ((float)Math.PI / 180)) : Vec3.ZERO;
            Vec3 velocity = this.getDeltaMovement();
            this.setDeltaMovement(desiredHorizontal.x, velocity.y, desiredHorizontal.z);
            if (!this.level().isClientSide) {
                this.hasImpulse = true;
            }
        }
    }

    protected void applyGravity() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.08, 0.0));
        }
    }

    private void applyFriction() {
        Vec3 motion = this.getDeltaMovement().multiply((double)DECELERATION.x(), (double)DECELERATION.y(), (double)DECELERATION.z());
        this.setDeltaMovement(motion);
    }

    private double getPassengerAttachmentOffset(Entity rider) {
        return this.getBbHeight() * 0.5f + -0.4f + rider.getBbHeight() * 0.1f;
    }

    private void updateOrientation() {
        if (this.isVehicle()) {
            this.setYBodyRot(this.getYRot());
            this.setYHeadRot(this.getYRot());
            return;
        }
        Vec3 velocity = this.getDeltaMovement();
        if (velocity.horizontalDistanceSqr() > 1.0E-4) {
            float targetYaw = (float)(Mth.atan2((double)velocity.z, (double)velocity.x) * 57.2957763671875) - 90.0f;
            this.rotateTowards(targetYaw, 8.0f);
            return;
        }
        this.yRotO = this.getYRot();
        this.setYBodyRot(this.getYRot());
        this.setYHeadRot(this.getYRot());
    }

    private boolean isMoving() {
        if (this.getControllingPassenger() == null) {
            return false;
        }
        boolean inputActive = this.level().isClientSide ? (this.isControlledByLocalInstance() ? this.hasMovementInput : (Boolean)this.entityData.get(DATA_MOVEMENT_INPUT)) : this.hasMovementInput;
        return inputActive || this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-4;
    }

    public boolean isControlledByLocalInstance() {
        Player player;
        LivingEntity controller = this.getControllingPassenger();
        return controller instanceof Player && (player = (Player)controller).isLocalPlayer();
    }

    private void updateRotationFromPassenger(LivingEntity passenger) {
        float targetYaw = passenger.getViewYRot(1.0f);
        this.rotateTowards(targetYaw, 40.0f);
    }

    private void rotateTowards(float targetYaw, float maxStep) {
        float previousYaw = this.getYRot();
        float angleDiff = Math.abs(Mth.degreesDifference((float)previousYaw, (float)targetYaw));
        float step = Mth.clamp((float)(angleDiff * 0.45f), (float)8.0f, (float)maxStep);
        float newYaw = Mth.approachDegrees((float)previousYaw, (float)targetYaw, (float)step);
        this.yRotO = previousYaw;
        this.setYRot(newYaw);
        this.setYBodyRot(newYaw);
        this.setYHeadRot(newYaw);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource source) {
        if (this.level().isClientSide) {
            return false;
        }
        LivingEntity passenger = this.getControllingPassenger();
        if (!(passenger instanceof Player)) {
            return false;
        }
        Player player = (Player)passenger;
        PokeBikeConfig config = PokeBikeConfig.get();
        if (fallDistance <= (float)config.bikeFallDamageNoDamageMaxBlocks) {
            return false;
        }
        if (!config.bikeFallDamageEnabled) {
            return false;
        }
        float rawDamage = (float)Math.ceil(fallDistance - (float)config.bikeFallDamageNoDamageMaxBlocks);
        float reducedDamage = rawDamage * damageMultiplier * 0.25f;
        if (reducedDamage <= 0.0f) {
            return false;
        }
        return player.hurt(source, reducedDamage);
    }

    private void handleLiquidContact() {
        LivingEntity rider;
        boolean justTouchedLava;
        boolean inWater = this.isInWaterOrBubble();
        boolean inLava = this.isInLava();
        boolean justTouchedWater = inWater && !this.wasInWater;
        boolean bl = justTouchedLava = inLava && !this.wasInLava;
        if ((justTouchedWater || justTouchedLava) && (rider = this.getControllingPassenger()) != null) {
            if (this.liquidMessageCooldownTicks == 0 && rider instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)rider;
                MutableComponent message = Component.literal((String)(justTouchedLava ? "The bike can\u2019t be used in lava." : "The bike can\u2019t be used in water."));
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
                this.liquidMessageCooldownTicks = 100;
            }
            this.ejectPassengers();
        }
        this.wasInWater = inWater;
        this.wasInLava = inLava;
    }

    private boolean isTouchingLiquid() {
        return this.isInWaterOrBubble() || this.isInLava();
    }
}

