/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.pokebike.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.levelscraft7.pokebike.PokeBike;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class PokeBikeConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "pokebike-server.json";
    private static PokeBikeConfig instance = new PokeBikeConfig();
    public boolean bikeFallDamageEnabled = true;
    public int bikeFallDamageNoDamageMaxBlocks = 4;
    public double bikeSpeedMultiplier = 1.0;
    public boolean requireWrenchToPickupBike = true;
    public boolean bikeOwnershipEnabled = true;

    private PokeBikeConfig() {
    }

    public static PokeBikeConfig get() {
        return instance;
    }

    public static void load() {
        PokeBikeConfig.loadInternal(false);
    }

    public static boolean reload() {
        return PokeBikeConfig.loadInternal(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadInternal(boolean isReload) {
        block17: {
            Path configPath = Platform.getConfigFolder().resolve(FILE_NAME);
            if (Files.exists(configPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (json != null) {
                        PokeBikeConfig loaded = new PokeBikeConfig();
                        if (json.has("bikeFallDamageEnabled")) {
                            loaded.bikeFallDamageEnabled = json.get("bikeFallDamageEnabled").getAsBoolean();
                        }
                        if (json.has("bikeFallDamageNoDamageMaxBlocks")) {
                            loaded.bikeFallDamageNoDamageMaxBlocks = json.get("bikeFallDamageNoDamageMaxBlocks").getAsInt();
                        }
                        if (json.has("bikeSpeedMultiplier")) {
                            loaded.bikeSpeedMultiplier = json.get("bikeSpeedMultiplier").getAsDouble();
                        }
                        if (json.has("requireWrenchToPickupBike")) {
                            loaded.requireWrenchToPickupBike = json.get("requireWrenchToPickupBike").getAsBoolean();
                        }
                        if (json.has("bikeOwnershipEnabled")) {
                            loaded.bikeOwnershipEnabled = json.get("bikeOwnershipEnabled").getAsBoolean();
                        }
                        loaded.sanitize();
                        instance = loaded;
                        if (isReload) {
                            PokeBike.LOGGER.info("Reloaded PokeBike server config: bikeFallDamageEnabled={}, bikeFallDamageNoDamageMaxBlocks={}, bikeSpeedMultiplier={}, requireWrenchToPickupBike={}, bikeOwnershipEnabled={}", new Object[]{loaded.bikeFallDamageEnabled, loaded.bikeFallDamageNoDamageMaxBlocks, loaded.bikeSpeedMultiplier, loaded.requireWrenchToPickupBike, loaded.bikeOwnershipEnabled});
                        }
                        boolean bl = true;
                        return bl;
                    }
                    break block17;
                }
                catch (JsonParseException | IOException | IllegalStateException e) {
                    PokeBike.LOGGER.warn("Failed to load PokeBike config.", e);
                    return false;
                }
            }
            if (!isReload) {
                PokeBikeConfig.save(configPath, instance);
            }
        }
        if (isReload) return false;
        return true;
    }

    private static void save(Path configPath, PokeBikeConfig config) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            PokeBike.LOGGER.warn("Failed to save PokeBike config.", (Throwable)e);
        }
    }

    private void sanitize() {
        if (this.bikeFallDamageNoDamageMaxBlocks < 0) {
            this.bikeFallDamageNoDamageMaxBlocks = 0;
        }
        if (this.bikeSpeedMultiplier <= 0.0) {
            this.bikeSpeedMultiplier = 1.0;
        }
    }
}

