/*
 * Decompiled with CFR 0.152.
 */
package com.levelscraft7.pokebike.client.render;

import com.levelscraft7.pokebike.client.model.BikeModel;
import com.levelscraft7.pokebike.entity.BikeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public final class BikeRenderer
extends GeoEntityRenderer<BikeEntity> {
    private static final ResourceLocation SHADOW_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/misc/shadow.png");

    public BikeRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new BikeModel());
        this.shadowRadius = 0.0f;
    }

    public RenderType getRenderType(BikeEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutout((ResourceLocation)texture);
    }

    public void render(BikeEntity animatable, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float previousShadowRadius = this.shadowRadius;
        this.shadowRadius = 0.0f;
        super.render((Entity)animatable, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
        this.shadowRadius = previousShadowRadius;
        if (!animatable.isInvisible() && ((Boolean)Minecraft.getInstance().options.entityShadows().get()).booleanValue()) {
            float halfWidth = 0.1f;
            float halfLength = 1.0f;
            poseStack.pushPose();
            poseStack.translate(0.0, 0.01, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(270.0f - entityYaw));
            this.renderStretchedShadow(poseStack, bufferSource, halfWidth, halfLength, this.shadowStrength);
            poseStack.popPose();
        }
    }

    protected float getDeathMaxRotation(BikeEntity animatable) {
        return 0.0f;
    }

    public Vec3 getRenderOffset(BikeEntity animatable, float partialTicks) {
        return Vec3.ZERO;
    }

    protected void applyRotations(BikeEntity animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        float interpolatedYaw = Mth.rotLerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot());
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, interpolatedYaw, partialTick, nativeScale);
    }

    private void renderStretchedShadow(PoseStack poseStack, MultiBufferSource bufferSource, float halfWidth, float halfLength, float strength) {
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityShadow((ResourceLocation)SHADOW_TEXTURE));
        PoseStack.Pose pose = poseStack.last();
        int shadowAlpha = 114;
        float minX = -halfLength;
        float maxX = halfLength;
        float minZ = -halfWidth;
        float maxZ = halfWidth;
        this.addShadowVertex(consumer, pose, minX, 0.0f, minZ, shadowAlpha, 0.0f, 0.0f);
        this.addShadowVertex(consumer, pose, minX, 0.0f, maxZ, shadowAlpha, 0.0f, 1.0f);
        this.addShadowVertex(consumer, pose, maxX, 0.0f, maxZ, shadowAlpha, 1.0f, 1.0f);
        this.addShadowVertex(consumer, pose, maxX, 0.0f, minZ, shadowAlpha, 1.0f, 0.0f);
    }

    private void addShadowVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int alpha, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(0, 0, 0, alpha).setUv(u, v).setUv1(0, 0).setUv2(0, 0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

