/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.recipe;

import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.registry.CFRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FurniCraftingRecipe
implements Recipe<SingleRecipeInput> {
    private final NonNullList<CountedIngredient> materials;
    private final ItemStack result;
    private final boolean notification;

    public FurniCraftingRecipe(NonNullList<CountedIngredient> materials, ItemStack result, boolean notification) {
        this.materials = materials;
        this.result = result;
        this.notification = notification;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        ItemStack inputStack = input.getItem(0);
        if (inputStack.isEmpty()) {
            return false;
        }
        for (CountedIngredient ci : this.materials) {
            if (!ci.ingredient().test(inputStack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return CFRecipes.FURNI_CRAFTING_SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return CFRecipes.FURNI_CRAFTING_RECIPE_TYPE;
    }

    public NonNullList<CountedIngredient> getMaterials() {
        return this.materials;
    }

    public ItemStack[] getMaterialStacks() {
        return (ItemStack[])this.materials.stream().map(ci -> {
            ItemStack[] stacks = ci.ingredient().getItems();
            if (stacks.length > 0) {
                ItemStack stack = stacks[0].copy();
                stack.setCount(ci.count());
                return stack;
            }
            return ItemStack.EMPTY;
        }).toArray(ItemStack[]::new);
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static class Type
    implements RecipeType<FurniCraftingRecipe> {
        public static final Type INSTANCE = new Type();
    }

    public static class Serializer
    implements RecipeSerializer<FurniCraftingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<FurniCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CountedIngredient.CODEC.listOf().fieldOf("materials").flatXmap(list -> DataResult.success((Object)NonNullList.of((Object)CountedIngredient.EMPTY, (Object[])list.toArray(new CountedIngredient[0]))), nonNullList -> DataResult.success(nonNullList.stream().toList())).forGetter(recipe -> recipe.materials), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)false).forGetter(recipe -> recipe.notification)).apply((Applicative)instance, FurniCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FurniCraftingRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            buf.writeVarInt(recipe.materials.size());
            for (CountedIngredient ci : recipe.materials) {
                buf.writeVarInt(ci.count());
                Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)ci.ingredient());
            }
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.result);
            buf.writeBoolean(recipe.notification);
        }, buf -> {
            int size = buf.readVarInt();
            NonNullList materials = NonNullList.create();
            for (int i = 0; i < size; ++i) {
                int count = buf.readVarInt();
                Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
                materials.add((Object)new CountedIngredient(ingredient, count));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            boolean notification = buf.readBoolean();
            return new FurniCraftingRecipe((NonNullList<CountedIngredient>)materials, result, notification);
        });

        public MapCodec<FurniCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FurniCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

