/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.menu.container;

import com.lunazstudios.cobblefurnies.menu.StoveMenu;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StoveContainer
extends TransientCraftingContainer {
    public final StoveMenu menu;
    public final NonNullList<ItemStack> items;

    public StoveContainer(StoveMenu menu, int width, int height) {
        super((AbstractContainerMenu)menu, width, height);
        this.menu = menu;
        this.items = NonNullList.withSize((int)20, (Object)ItemStack.EMPTY);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int index) {
        if (index >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        if (index >= 0 && index < this.getContainerSize()) {
            this.items.set(index, (Object)stack);
            if (this.menu != null) {
                this.menu.slotsChanged((Container)this);
            }
        }
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        ItemStack stack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        if (!stack.isEmpty() && this.menu != null) {
            this.menu.slotsChanged((Container)this);
        }
        return stack;
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public int getHeight() {
        return 3;
    }

    public int getWidth() {
        return 3;
    }

    @NotNull
    public List<ItemStack> getItems() {
        return this.items;
    }

    public void fillStackedContents(@NotNull StackedContents helper) {
        for (ItemStack stack : this.items) {
            helper.accountSimpleStack(stack);
        }
    }
}

