/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.menu;

import com.cobblemon.mod.common.CobblemonRecipeTypes;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.item.crafting.CookingPotRecipe;
import com.cobblemon.mod.common.item.crafting.CookingPotRecipeBase;
import com.lunazstudios.cobblefurnies.menu.container.StoveContainer;
import com.lunazstudios.cobblefurnies.menu.slot.SeasoningSlot;
import com.lunazstudios.cobblefurnies.menu.slot.StoveResultSlot;
import com.lunazstudios.cobblefurnies.registry.CFMenus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StoveMenu
extends RecipeBookMenu<CraftingInput, CookingPotRecipeBase>
implements ContainerListener {
    private final Player player;
    private final Level level;
    private final Inventory playerInventory;
    public final CraftingContainer container;
    private final ResultContainer resultContainer;
    public final ContainerData containerData;
    private final RecipeType<CookingPotRecipe> recipeType = CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_COOKING();
    private final RecipeManager.CachedCheck<CraftingInput, CookingPotRecipe> quickCheck = RecipeManager.createCheck((RecipeType)CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_COOKING());
    public RecipeHolder<CookingPotRecipeBase> currentActiveRecipe = null;
    public ItemStack previewItem = ItemStack.EMPTY;
    public static final int RESULT_SLOT = 0;
    public static final int CRAFTING_GRID_WIDTH = 3;
    public static final int ITEMS_SIZE = 20;
    public static final int CRAFTING_GRID_START = 1;
    public static final int CRAFTING_GRID_END = 9;
    public static final int SEASONING_START = 10;
    public static final int SEASONING_END = 12;
    public static final int PLAYER_INV_START = 13;
    public static final int PLAYER_INV_END = 39;
    public static final int PLAYER_HOTBAR_START = 40;
    public static final int PLAYER_HOTBAR_END = 48;

    public StoveMenu(int containerId, Inventory playerInventory) {
        super(CFMenus.STOVE_MENU.get(), containerId);
        this.playerInventory = playerInventory;
        this.container = new StoveContainer(this, 3, 3);
        this.resultContainer = new ResultContainer();
        this.containerData = new SimpleContainerData(4);
        this.addDataSlots(this.containerData);
        this.player = playerInventory.player;
        this.level = playerInventory.player.level();
        this.initializeSlots(playerInventory);
        this.addSlotListener(this);
    }

    public StoveMenu(int containerId, Inventory playerInventory, CraftingContainer container, ContainerData containerData) {
        super(CFMenus.STOVE_MENU.get(), containerId);
        this.playerInventory = playerInventory;
        this.container = container;
        this.containerData = containerData;
        this.addDataSlots(containerData);
        this.resultContainer = new ResultContainer();
        this.player = playerInventory.player;
        this.level = playerInventory.player.level();
        container.startOpen(playerInventory.player);
        this.initializeSlots(playerInventory);
        this.addSlotListener(this);
    }

    private void initializeSlots(Inventory playerInventory) {
        int col;
        int row;
        int i;
        int resultSlotX = 128;
        int resultSlotY = 55;
        this.addSlot(new StoveResultSlot(this.container, 0, resultSlotX, resultSlotY));
        for (i = 0; i < 9; ++i) {
            row = i / 3;
            col = i % 3;
            this.addSlot(new Slot((Container)this.container, 1 + i, 33 + col * 18, 18 + row * 18));
        }
        for (i = 0; i < 3; ++i) {
            this.addSlot(new SeasoningSlot(this, (Container)this.container, 10 + i, 110 + i * 18, 18));
        }
        for (i = 0; i < 27; ++i) {
            row = i / 9;
            col = i % 9;
            this.addSlot(new Slot((Container)playerInventory, i + 9, 8 + col * 18, 84 + row * 18));
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePlacement(boolean placeAll, RecipeHolder<?> recipe, ServerPlayer player) {
        Recipe recipeValue = recipe.value();
        if (recipeValue instanceof CookingPotRecipeBase) {
            RecipeHolder<?> castedRecipe = recipe;
            ArrayList<ItemStack> preservedSeasonings = new ArrayList<ItemStack>();
            for (int i = 10; i <= 12; ++i) {
                preservedSeasonings.add(this.container.getItem(i).copy());
            }
            this.beginPlacingRecipe();
            try {
                ServerPlaceRecipe serverPlaceRecipe = new ServerPlaceRecipe((RecipeBookMenu)this);
                serverPlaceRecipe.recipeClicked(player, castedRecipe, placeAll);
            }
            finally {
                this.finishPlacingRecipe(castedRecipe);
            }
            for (int i = 0; i < preservedSeasonings.size(); ++i) {
                this.container.setItem(10 + i, (ItemStack)preservedSeasonings.get(i));
            }
        } else {
            throw new IllegalArgumentException("Unsupported recipe type: " + recipeValue.getClass().getName());
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public void fillCraftSlotsStackedContents(StackedContents itemHelper) {
        this.container.fillStackedContents(itemHelper);
    }

    public void clearCraftingContent() {
        this.container.clearContent();
    }

    public boolean recipeMatches(RecipeHolder<CookingPotRecipeBase> recipe) {
        List craftingItems = this.container.getItems().subList(1, 10);
        CraftingInput craftInput = CraftingInput.of((int)3, (int)3, craftingItems);
        CookingPotRecipeBase recipeValue = (CookingPotRecipeBase)recipe.value();
        return recipeValue.matches(craftInput, this.level);
    }

    private void recalculateRecipe() {
        List craftingItems = this.container.getItems().subList(1, 10);
        CraftingInput craftInput = CraftingInput.of((int)3, (int)3, craftingItems);
        Optional<RecipeHolder<CookingPotRecipeBase>> recipe = this.fetchRecipe(CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_COOKING()).or(() -> this.fetchRecipe(CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_SHAPELESS()));
        this.currentActiveRecipe = recipe.orElse(null);
        if (recipe.isPresent()) {
            CookingPotRecipeBase recipeValue = (CookingPotRecipeBase)recipe.get().value();
            this.previewItem = recipeValue.assemble(craftInput, (HolderLookup.Provider)this.level.registryAccess());
            ArrayList<ItemStack> seasonings = new ArrayList<ItemStack>();
            for (int i = 10; i <= 12; ++i) {
                ItemStack stack = this.container.getItem(i);
                if (stack.isEmpty() || !stack.is(recipeValue.getSeasoningTag())) continue;
                seasonings.add(stack);
            }
            recipeValue.applySeasoning(this.previewItem, seasonings);
        } else {
            this.previewItem = ItemStack.EMPTY;
        }
    }

    private <T extends CookingPotRecipeBase> Optional<RecipeHolder<CookingPotRecipeBase>> fetchRecipe(RecipeType<T> recipeType) {
        List craftingItems = this.container.getItems().subList(1, 10);
        CraftingInput craftInput = CraftingInput.of((int)3, (int)3, craftingItems);
        Optional optional = this.level.getRecipeManager().getRecipeFor(recipeType, (RecipeInput)craftInput, this.level);
        return optional.map(holder -> holder);
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return 3;
    }

    public int getGridHeight() {
        return 3;
    }

    public int getSize() {
        return 20;
    }

    public float getBurnProgress() {
        int current = this.containerData.get(0);
        int total = this.containerData.get(1);
        if (total != 0 && current != 0) {
            return Mth.clamp((float)((float)current / (float)total), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    @NotNull
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.valueOf((String)"COBBLEMON_COOKING_POT");
    }

    public boolean shouldMoveToInventory(int slotIndex) {
        return slotIndex < 10 || slotIndex > 12;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItemStack = slot.getItem();
            itemStack = slotItemStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(slotItemStack, 13, 49, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotItemStack, itemStack);
            } else if (index >= 13 && index <= 48 ? (Seasonings.INSTANCE.isSeasoning(slotItemStack) ? !this.moveItemStackTo(slotItemStack, 1, 10, false) && !this.moveItemStackTo(slotItemStack, 10, 13, false) : !this.moveItemStackTo(slotItemStack, 1, 10, false)) : (index >= 1 && index <= 9 || index >= 10 && index <= 12) && !this.moveItemStackTo(slotItemStack, 13, 49, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItemStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItemStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItemStack);
        }
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.container.stillValid(player);
    }

    public void slotChanged(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
        if (dataSlotIndex >= 1 && dataSlotIndex <= 9 || dataSlotIndex >= 10 && dataSlotIndex <= 12) {
            this.recalculateRecipe();
        }
        this.broadcastChanges();
    }

    public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
    }
}

