/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.menu;

import com.lunazstudios.cobblefurnies.block.entity.FurniCrafterBlockEntity;
import com.lunazstudios.cobblefurnies.network.message.SyncCraftableRecipesMessage;
import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.recipe.FurniCraftingRecipe;
import com.lunazstudios.cobblefurnies.registry.CFMenus;
import com.lunazstudios.cobblefurnies.registry.CFRecipes;
import dev.architectury.networking.NetworkManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FurniCrafterMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Player player;
    private final Level level;
    private final FurniCrafterBlockEntity blockEntity;
    private final SimpleContainer outputContainer;
    private List<RecipeHolder<FurniCraftingRecipe>> availableRecipes;
    private List<Boolean> canCraftRecipes;
    private static final int OUTPUT_SLOT_INDEX = 0;

    public FurniCrafterMenu(int id, Inventory inventory, Level level, BlockPos pos, SimpleContainer outputContainer) {
        super(CFMenus.FURNI_CRAFTER_MENU.get(), id);
        FurniCrafterBlockEntity entity;
        this.access = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        this.player = inventory.player;
        this.level = level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        this.blockEntity = blockEntity instanceof FurniCrafterBlockEntity ? (entity = (FurniCrafterBlockEntity)blockEntity) : null;
        this.outputContainer = outputContainer;
        this.fetchAvailableRecipes();
        this.addPlayerInventorySlots(inventory);
        this.addOutputSlot();
        this.updateCraftableRecipes();
    }

    public FurniCrafterMenu(int id, Inventory inventory, Level level, BlockPos pos) {
        this(id, inventory, level, pos, new SimpleContainer(1));
    }

    public FurniCrafterMenu(int id, Inventory inventory, FriendlyByteBuf buf) {
        this(id, inventory, inventory.player.level(), buf.readBlockPos(), new SimpleContainer(1));
    }

    public FurniCrafterMenu(int id, Inventory inventory) {
        this(id, inventory, inventory.player.level(), BlockPos.ZERO, new SimpleContainer(1));
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.updateCraftableRecipes();
    }

    public void updateCraftableRecipes() {
        this.canCraftRecipes = this.availableRecipes.stream().map(r -> this.canCraft((FurniCraftingRecipe)r.value())).collect(Collectors.toList());
        this.syncCraftableRecipesToClient();
    }

    private void syncCraftableRecipesToClient() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean[] craftable = new boolean[this.canCraftRecipes.size()];
        for (int i = 0; i < this.canCraftRecipes.size(); ++i) {
            craftable[i] = this.canCraftRecipes.get(i);
        }
        SyncCraftableRecipesMessage message = new SyncCraftableRecipesMessage(this.containerId, craftable);
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)message);
    }

    private void fetchAvailableRecipes() {
        this.availableRecipes = this.level.getRecipeManager().getAllRecipesFor(CFRecipes.FURNI_CRAFTING_RECIPE_TYPE).stream().sorted(Comparator.comparing(RecipeHolder::id)).collect(Collectors.toList());
    }

    public List<RecipeHolder<FurniCraftingRecipe>> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public boolean canCraft(FurniCraftingRecipe recipe) {
        for (CountedIngredient ci : recipe.getMaterials()) {
            int requiredCount = ci.count();
            int totalCount = 0;
            for (ItemStack stack : this.player.getInventory().items) {
                if (stack.isEmpty() || !ci.ingredient().test(stack)) continue;
                totalCount += stack.getCount();
            }
            if (totalCount >= requiredCount) continue;
            return false;
        }
        return true;
    }

    private void addPlayerInventorySlots(Inventory inventory) {
        int yOffset = 38;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inventory, col + row * 9 + 9, 8 + col * 18, 84 + yOffset + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)inventory, col, 8 + col * 18, 142 + yOffset));
        }
    }

    private void addOutputSlot() {
        this.addSlot(new Slot(this, (Container)this.outputContainer, 0, 149, 86){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
    }

    public void craftSelectedRecipe(int recipeIndex) {
        if (recipeIndex < 0 || recipeIndex >= this.availableRecipes.size() || this.blockEntity == null) {
            return;
        }
        RecipeHolder<FurniCraftingRecipe> recipeHolder = this.availableRecipes.get(recipeIndex);
        FurniCraftingRecipe recipe = (FurniCraftingRecipe)recipeHolder.value();
        if (!this.canCraft(recipe)) {
            return;
        }
        ItemStack result = recipe.getResultItem(null);
        ItemStack outputSlot = this.outputContainer.getItem(0);
        if (!(outputSlot.isEmpty() || outputSlot.is(result.getItem()) && outputSlot.getCount() + result.getCount() <= outputSlot.getMaxStackSize())) {
            return;
        }
        for (CountedIngredient ci : recipe.getMaterials()) {
            this.removeItemsFromInventory(ci);
        }
        if (outputSlot.isEmpty()) {
            this.outputContainer.setItem(0, result.copy());
        } else {
            outputSlot.grow(result.getCount());
        }
    }

    private void removeItemsFromInventory(CountedIngredient ci) {
        int requiredCount;
        int remaining = requiredCount = ci.count();
        for (int i = 0; i < this.player.getInventory().items.size(); ++i) {
            ItemStack stack = (ItemStack)this.player.getInventory().items.get(i);
            if (stack.isEmpty() || !ci.ingredient().test(stack)) continue;
            int take = Math.min(stack.getCount(), remaining);
            stack.shrink(take);
            if ((remaining -= take) <= 0) break;
        }
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.access.evaluate((level, pos) -> level.getBlockEntity(pos) instanceof FurniCrafterBlockEntity, (Object)true);
    }

    public void setCraftableRecipes(boolean[] canCraft) {
        for (int i = 0; i < canCraft.length && i < this.canCraftRecipes.size(); ++i) {
            this.canCraftRecipes.set(i, canCraft[i]);
        }
    }

    public boolean hasMaterials(CountedIngredient material, Map<Integer, Integer> counted) {
        int required = material.count();
        for (ItemStack stack : this.player.getInventory().items) {
            if (stack.isEmpty() || !material.ingredient().test(stack)) continue;
            int key = stack.getItem().hashCode();
            int alreadyUsed = counted.getOrDefault(key, 0);
            int available = stack.getCount() - alreadyUsed;
            if (available <= 0) continue;
            int used = Math.min(required, available);
            counted.put(key, alreadyUsed + used);
            if ((required -= used) > 0) continue;
            return true;
        }
        return false;
    }
}

