/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.entity;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.lunazstudios.cobblefurnies.block.SeatBlock;
import com.lunazstudios.cobblefurnies.registry.CFEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SeatEntity
extends Entity {
    public SeatEntity(Level level) {
        super(CFEntityTypes.SEAT.get(), level);
        this.noPhysics = true;
    }

    public SeatEntity(Level level, BlockPos pos) {
        this(level);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.001, (double)pos.getZ() + 0.5);
    }

    public void tick() {
        boolean canSit;
        if (this.level().isClientSide) {
            return;
        }
        BlockState state = this.level().getBlockState(this.blockPosition());
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            canSit = seatBlock.isSittable(state);
        } else {
            canSit = false;
        }
        if (this.isVehicle() && canSit) {
            return;
        }
        this.discard();
        this.level().updateNeighbourForOutputSignal(this.blockPosition(), this.level().getBlockState(this.blockPosition()).getBlock());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(new Vec3(0.0, this.getPassengersRidingOffset(), 0.0));
    }

    public double getPassengersRidingOffset() {
        List passengers = this.getPassengers();
        if (passengers.isEmpty()) {
            return 0.0;
        }
        double seatHeight = 0.0;
        BlockState state = this.level().getBlockState(this.blockPosition());
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            seatHeight = seatBlock.seatHeight(state);
        }
        return seatHeight + SeatEntity.getEntitySeatOffset((Entity)passengers.getFirst());
    }

    public static double getEntitySeatOffset(Entity entity) {
        if (entity instanceof Slime) {
            return 0.25;
        }
        if (entity instanceof Parrot) {
            return 0.0625;
        }
        if (entity instanceof Skeleton) {
            return 0.125;
        }
        if (entity instanceof Creeper) {
            return 0.25;
        }
        if (entity instanceof Cat) {
            return 0.125;
        }
        if (entity instanceof Wolf) {
            return 0.0625;
        }
        if (entity instanceof PokemonEntity) {
            return 0.0625;
        }
        return 0.0;
    }

    protected boolean canRide(Entity entity) {
        return true;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return super.getAddEntityPacket(entity);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        Direction[] offsets;
        Vec3 safeVec;
        BlockPos pos = this.blockPosition();
        BlockState state = this.level().getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            safeVec = DismountHelper.findSafeDismountLocation((EntityType)entity.getType(), (CollisionGetter)this.level(), (BlockPos)seatBlock.primaryDismountLocation(this.level(), state, pos), (boolean)false);
            if (safeVec != null) {
                return safeVec.add(0.0, 0.25, 0.0);
            }
        }
        Direction original = this.getDirection();
        for (Direction dir : offsets = new Direction[]{original, original.getClockWise(), original.getCounterClockWise(), original.getOpposite()}) {
            safeVec = DismountHelper.findSafeDismountLocation((EntityType)entity.getType(), (CollisionGetter)this.level(), (BlockPos)pos.relative(dir), (boolean)false);
            if (safeVec == null) continue;
            return safeVec.add(0.0, 0.25, 0.0);
        }
        return super.getDismountLocationForPassenger(entity);
    }

    protected void addPassenger(Entity passenger) {
        BlockPos pos = this.blockPosition();
        BlockState state = this.level().getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            passenger.setYRot(seatBlock.setRiderRotation(state, passenger));
        }
        super.addPassenger(passenger);
    }

    protected void removePassenger(Entity entity) {
        super.removePassenger(entity);
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.setInSittingPose(false);
        }
    }
}

