/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.screen;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.block.campfirepot.CampfirePotColor;
import com.cobblemon.mod.common.client.gui.cookingpot.CookButton;
import com.cobblemon.mod.common.integration.jei.CobblemonJeiPlugin;
import com.cobblemon.mod.common.integration.jei.cooking.CampfirePotRecipeCategory;
import com.cobblemon.mod.common.item.crafting.CookingPotRecipeBase;
import com.cobblemon.mod.common.mixin.accessor.RecipeBookComponentAccessor;
import com.lunazstudios.cobblefurnies.menu.StoveMenu;
import com.lunazstudios.cobblefurnies.menu.slot.SeasoningSlot;
import com.lunazstudios.cobblefurnies.network.message.ToggleStoveLidMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class StoveScreen
extends AbstractContainerScreen<StoveMenu>
implements RecipeUpdateListener {
    private static final int BACKGROUND_HEIGHT = 166;
    private static final int BACKGROUND_WIDTH = 176;
    public static final int COOK_PROGRESS_HEIGHT = 12;
    public static final int COOK_PROGRESS_WIDTH = 22;
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/campfirepot/campfire_pot.png");
    public static final ResourceLocation COOK_PROGRESS_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/campfirepot/cook_progress.png");
    private static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/campfire_pot_filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/campfire_pot_filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/campfire_pot_filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/campfire_pot_filter_disabled_highlighted"));
    private final RecipeBookComponent recipeBookComponent = new RecipeBookComponent();
    private boolean widthTooNarrow = false;
    private CookButton cookButton;

    public StoveScreen(StoveMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, (Component)Component.translatable((String)"container.cobblefurnies.stove"));
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void containerTick() {
        super.containerTick();
        this.recipeBookComponent.tick();
    }

    protected void init() {
        int topPos;
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.recipeBookComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
        if (this.recipeBookComponent.isVisible()) {
            StateSwitchingButton recipeBookFilterButton = ((RecipeBookComponentAccessor)this.recipeBookComponent).getFilterButton();
            this.overrideRecipeBookFilterButton(recipeBookFilterButton);
        }
        this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
        this.topPos = topPos = (this.height - 166) / 2;
        ImageButton recipeBookButton = new ImageButton(this.leftPos + 5, topPos + 35, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
            this.recipeBookComponent.toggleVisibility();
            if (this.recipeBookComponent.isVisible()) {
                StateSwitchingButton filterButton = ((RecipeBookComponentAccessor)this.recipeBookComponent).getFilterButton();
                this.overrideRecipeBookFilterButton(filterButton);
            }
            this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
            button.setPosition(this.leftPos + 5, topPos + 35);
        });
        this.addWidget((GuiEventListener)this.recipeBookComponent);
        this.addRenderableWidget((GuiEventListener)recipeBookButton);
        this.titleLabelX = this.imageWidth - 88 - this.font.width((FormattedText)this.title) / 2;
        this.titleLabelY = 6;
        if (this.cookButton != null) {
            this.removeWidget((GuiEventListener)this.cookButton);
        }
        int colorIndex = ((StoveMenu)this.menu).containerData.get(3);
        colorIndex = Math.max(0, Math.min(colorIndex, CampfirePotColor.values().length - 1));
        CampfirePotColor color = CampfirePotColor.values()[colorIndex];
        boolean isLidClosed = ((StoveMenu)this.menu).containerData.get(2) == 0;
        this.cookButton = new CookButton(this.leftPos + 97, topPos + 56, isLidClosed, color, button -> NetworkManager.sendToServer((CustomPacketPayload)new ToggleStoveLidMessage(((StoveMenu)this.menu).containerId)));
        this.addRenderableWidget((GuiEventListener)this.cookButton);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics context, float partialTick, int mouseX, int mouseY) {
        int x = this.leftPos;
        int y = (this.height - 166) / 2;
        GuiUtilsKt.blitk((PoseStack)context.pose(), (ResourceLocation)BACKGROUND, (Number)x, (Number)y, (Number)166, (Number)176);
        int cookProgress = (int)Math.ceil(((StoveMenu)this.menu).getBurnProgress() * 22.0f);
        GuiUtilsKt.blitk((PoseStack)context.pose(), (ResourceLocation)COOK_PROGRESS_SPRITE, (Number)(x + 96), (Number)(y + 39), (Number)12, (Number)cookProgress, (Number)0, (Number)0, (Number)22);
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        int colorIndex = ((StoveMenu)this.menu).containerData.get(3);
        colorIndex = Math.max(0, Math.min(colorIndex, CampfirePotColor.values().length - 1));
        this.cookButton.setColor(CampfirePotColor.values()[colorIndex]);
        this.cookButton.setSelected(((StoveMenu)this.menu).containerData.get(2) == 0);
        this.cookButton.setPosition(this.leftPos + 97, this.topPos + 56);
        if (this.recipeBookComponent.isVisible() && this.widthTooNarrow) {
            this.renderBackground(context, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.render(context, mouseX, mouseY, partialTicks);
        } else {
            super.render(context, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.render(context, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.renderGhostRecipe(context, this.leftPos, this.topPos, true, partialTicks);
        }
        Slot resultSlot = (Slot)((StoveMenu)this.menu).slots.get(((StoveMenu)this.menu).getResultSlotIndex());
        RecipeHolder<CookingPotRecipeBase> optionalRecipe = ((StoveMenu)this.menu).currentActiveRecipe;
        if (optionalRecipe != null && !((StoveMenu)this.menu).previewItem.isEmpty() && !resultSlot.hasItem()) {
            ItemStack resultItem = ((StoveMenu)this.menu).previewItem;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.renderFakeItem(resultItem, this.leftPos + resultSlot.x, this.topPos + resultSlot.y);
            context.renderItemDecorations(this.font, resultItem, this.leftPos + resultSlot.x, this.topPos + resultSlot.y);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            if (this.isHovering(resultSlot.x, resultSlot.y, 16, 16, mouseX, mouseY) && ((StoveMenu)this.menu).getCarried().isEmpty()) {
                context.renderTooltip(this.font, this.getTooltipFromContainerItem(resultItem), resultItem.getTooltipImage(), mouseX, mouseY);
            }
        }
        this.renderTooltip(context, mouseX, mouseY);
        this.recipeBookComponent.renderTooltip(context, this.leftPos, this.topPos, mouseX, mouseY);
    }

    protected void renderSlot(@NotNull GuiGraphics guiGraphics, @NotNull Slot slot) {
        if (slot instanceof SeasoningSlot) {
            boolean shouldDarken;
            boolean bl = shouldDarken = !((StoveMenu)this.menu).getCarried().isEmpty() && !slot.mayPlace(((StoveMenu)this.menu).getCarried()) || slot.hasItem() && !slot.mayPlace(slot.getItem());
            if (shouldDarken) {
                int x = slot.x;
                int y = slot.y;
                guiGraphics.fill(x, y, x + 16, y + 16, 0x30FF0000);
            }
        }
        super.renderSlot(guiGraphics, slot);
    }

    public void recipesUpdated() {
        this.recipeBookComponent.recipesUpdated();
    }

    @NotNull
    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookComponent;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int progressX = this.leftPos + 96;
        int progressY = this.topPos + 39;
        if (Cobblemon.INSTANCE.getImplementation().isModInstalled("jei") && mouseX >= (double)progressX && mouseX < (double)(progressX + 22) && mouseY >= (double)progressY && mouseY < (double)(progressY + 12)) {
            if (CobblemonJeiPlugin.Companion.getJeiRuntime() != null) {
                CobblemonJeiPlugin.Companion.getJeiRuntime().getRecipesGui().showTypes(List.of(CampfirePotRecipeCategory.Companion.getRECIPE_TYPE()));
            }
            return true;
        }
        if (this.recipeBookComponent.mouseClicked(mouseX, mouseY, button)) {
            StateSwitchingButton recipeBookFilterButton;
            this.setFocused((GuiEventListener)this.recipeBookComponent);
            if (this.recipeBookComponent.isVisible() && (recipeBookFilterButton = ((RecipeBookComponentAccessor)this.recipeBookComponent).getFilterButton()).isMouseOver(mouseX, mouseY)) {
                this.overrideRecipeBookFilterButton(recipeBookFilterButton);
            }
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.isVisible() || super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int progressX = this.leftPos + 96;
        int progressY = this.topPos + 39;
        if (Cobblemon.INSTANCE.getImplementation().isModInstalled("jei") && mouseX >= progressX && mouseX < progressX + 22 && mouseY >= progressY && mouseY < progressY + 12) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"jei.tooltip.show.recipes"), mouseX, mouseY);
            return;
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void overrideRecipeBookFilterButton(StateSwitchingButton filterButton) {
        filterButton.initTextureValues(FILTER_BUTTON_SPRITES);
        filterButton.setTooltip(filterButton.isStateTriggered() ? Tooltip.create((Component)Component.translatable((String)"cobblemon.container.campfire_pot.recipe_book.toggle_recipes")) : Tooltip.create((Component)Component.translatable((String)"gui.recipebook.toggleRecipes.all")));
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        this.recipeBookComponent.slotClicked(slot);
    }
}

