/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.screen;

import com.lunazstudios.cobblefurnies.client.screen.ClientFurnicrafterRecipeIngredientTooltip;
import com.lunazstudios.cobblefurnies.client.screen.ClientFurnicrafterRecipeTooltip;
import com.lunazstudios.cobblefurnies.menu.FurniCrafterMenu;
import com.lunazstudios.cobblefurnies.mixin.client.GuiGraphicsInvoker;
import com.lunazstudios.cobblefurnies.network.message.CraftRecipeMessage;
import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.recipe.FurniCraftingRecipe;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;

public class FurniCrafterScreen
extends AbstractContainerScreen<FurniCrafterMenu> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cobblefurnies", (String)"textures/gui/container/furnicrafter.png");
    private static final int RECIPES_PER_ROW = 6;
    private static final int BUTTON_SIZE = 20;
    private static final int GRID_X_OFFSET = 7;
    private static final int GRID_Y_OFFSET = 18;
    private static final int WINDOW_WIDTH = 120;
    private static final int WINDOW_HEIGHT = 88;
    private static final int SCROLL_SPEED = 10;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int SCROLLBAR_AREA = 88;
    private static final int SCROLLBAR_TEXTURE_ENABLED_X = 176;
    private static final int SCROLLBAR_TEXTURE_DISABLED_X = 188;
    private static final int SCROLLBAR_TEXTURE_Y = 40;
    private static final int Y_OFFSET_CORRECTION = 0;
    private List<FurniCraftingRecipe> recipes = new ArrayList<FurniCraftingRecipe>();
    private double scroll = 0.0;
    private int hoveredRecipeIndex = -1;
    private int clickedY = -1;
    private int scrollbarDragOffset = 0;

    public FurniCrafterScreen(FurniCrafterMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 204;
        this.inventoryLabelY = 110;
        this.updateRecipes();
    }

    private void updateRecipes() {
        this.recipes = ((FurniCrafterMenu)this.menu).getAvailableRecipes().stream().map(RecipeHolder::value).toList();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.hoveredRecipeIndex != -1 && this.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 7, this.topPos + 18, 120, 88)) {
            this.renderRecipeTooltip(graphics, mouseX, mouseY, this.hoveredRecipeIndex);
        }
    }

    private void renderRecipeTooltip(GuiGraphics graphics, int mouseX, int mouseY, int recipeIndex) {
        RecipeHolder<FurniCraftingRecipe> holder = ((FurniCrafterMenu)this.menu).getAvailableRecipes().get(recipeIndex);
        FurniCraftingRecipe recipe = (FurniCraftingRecipe)holder.value();
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        components.add((ClientTooltipComponent)new ClientTextTooltip(recipe.getResultItem(null).getHoverName().getVisualOrderText()));
        if (!Screen.hasShiftDown()) {
            components.add(new ClientFurnicrafterRecipeTooltip((FurniCrafterMenu)this.menu, recipe));
            components.add((ClientTooltipComponent)new ClientTextTooltip(Component.translatable((String)"gui.cobblefurnies.hold_shift_for_details").withStyle(ChatFormatting.GRAY).getVisualOrderText()));
        } else {
            HashMap<Integer, Integer> counted = new HashMap<Integer, Integer>();
            for (CountedIngredient ingredient : recipe.getMaterials()) {
                components.add(new ClientFurnicrafterRecipeIngredientTooltip((FurniCrafterMenu)this.menu, ingredient, counted));
            }
        }
        ((GuiGraphicsInvoker)graphics).invokeRenderTooltipInternal(this.font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderRecipes(graphics, mouseX, mouseY);
        this.renderScrollbar(graphics);
    }

    private void renderRecipes(GuiGraphics graphics, int mouseX, int mouseY) {
        this.hoveredRecipeIndex = -1;
        int clipX = this.leftPos + 7;
        int clipY = this.topPos + 18;
        graphics.enableScissor(clipX, clipY, clipX + 120, clipY + 88);
        int totalRecipes = this.recipes.size();
        int startRow = (int)(this.scroll / 20.0);
        int startIndex = startRow * 6;
        int rowsToDraw = (int)Math.ceil(4.4) + 1;
        int endIndex = Math.min(totalRecipes, startIndex + rowsToDraw * 6);
        boolean mouseInGrid = this.isMouseWithinBounds(mouseX, mouseY, clipX, clipY, 120, 88);
        for (int i = startIndex; i < endIndex; ++i) {
            int row = i / 6;
            int col = i % 6;
            int x = this.leftPos + 7 + col * 20;
            int y = this.topPos + 18 + row * 20 - (int)this.scroll - 0;
            boolean canCraft = ((FurniCrafterMenu)this.menu).canCraft(this.recipes.get(i));
            int textureU = 176 + (!canCraft ? 20 : 0);
            boolean textureV = false;
            graphics.blit(TEXTURE, x, y, (float)textureU, (float)textureV, 20, 20, 256, 256);
            graphics.renderFakeItem(this.recipes.get(i).getResultItem(null), x + 2, y + 2);
            if (!mouseInGrid || mouseX < x || mouseX >= x + 20 || mouseY < y || mouseY >= y + 20) continue;
            this.hoveredRecipeIndex = i;
        }
        graphics.disableScissor();
    }

    private void renderScrollbar(GuiGraphics graphics) {
        int maxScroll = this.getMaxScroll();
        int scrollbarX = this.leftPos + 7 + 120 + 3;
        int scrollbarY = this.topPos + 18 - 0;
        int trackHeight = 73;
        int currentHandlePos = maxScroll > 0 ? (int)(this.scroll / (double)maxScroll * (double)trackHeight) : 0;
        int textureX = maxScroll > 0 ? 176 : 188;
        graphics.blit(TEXTURE, scrollbarX, scrollbarY + currentHandlePos, (float)textureX, 40.0f, 12, 15, 256, 256);
    }

    private int getMaxScroll() {
        int totalRows = (int)Math.ceil((double)this.recipes.size() / 6.0);
        return Math.max(0, totalRows * 20 - 88);
    }

    private boolean isMouseWithinBounds(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int currentHandlePos;
            if (this.hoveredRecipeIndex != -1) {
                this.craftItem(this.hoveredRecipeIndex);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
            int scrollbarX = this.leftPos + 7 + 120 + 3;
            int scrollbarY = this.topPos + 18 - 0;
            int maxScroll = this.getMaxScroll();
            int trackHeight = 73;
            int n = currentHandlePos = maxScroll > 0 ? (int)(this.scroll / (double)maxScroll * (double)trackHeight) : 0;
            if (this.isMouseWithinBounds(mouseX, mouseY, scrollbarX, scrollbarY + currentHandlePos, 12, 15)) {
                this.scrollbarDragOffset = (int)mouseY - (scrollbarY + currentHandlePos);
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedY != -1) {
            int scrollbarY = this.topPos + 18 - 0;
            int trackHeight = 73;
            int newHandlePos = (int)mouseY - scrollbarY - this.scrollbarDragOffset;
            newHandlePos = Mth.clamp((int)newHandlePos, (int)0, (int)trackHeight);
            this.scroll = (double)newHandlePos / (double)trackHeight * (double)this.getMaxScroll();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY != -1) {
            this.clickedY = -1;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.clickedY == -1 && this.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 7, this.topPos + 18, 135, 88)) {
            this.scroll = Mth.clamp((double)(this.scroll - deltaY * 10.0), (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void craftItem(int recipeIndex) {
        CraftRecipeMessage message = new CraftRecipeMessage(((FurniCrafterMenu)this.menu).containerId, recipeIndex);
        NetworkManager.sendToServer((CustomPacketPayload)message);
    }

    public void updateRecipeButtons() {
        this.updateRecipes();
    }
}

