/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.renderer.block;

import com.lunazstudios.cobblefurnies.block.entity.StatueBlockEntity;
import com.lunazstudios.cobblefurnies.client.bbmodel.BBModel;
import com.lunazstudios.cobblefurnies.client.bbmodel.BBRenderer;
import com.lunazstudios.cobblefurnies.registry.CFBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class StatueBlockRenderer
implements BlockEntityRenderer<StatueBlockEntity> {
    private static final DirectionProperty H_FACING = HorizontalDirectionalBlock.FACING;
    private final Map<String, BBModel> modelCache = new HashMap<String, BBModel>();
    private final Map<String, ResourceLocation> textureCache = new HashMap<String, ResourceLocation>();

    public StatueBlockRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(StatueBlockEntity be, float partialTicks, PoseStack ps, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        if (be == null || be.getLevel() == null) {
            return;
        }
        BlockState state = be.getBlockState();
        Block block = state.getBlock();
        String key = this.typeKey(block);
        BBModel model = this.modelCache.computeIfAbsent(key, k -> {
            ResourceLocation rl = this.modelPathFor((String)k);
            return BBModel.load(rl);
        });
        ResourceLocation texture = this.textureCache.computeIfAbsent(key, this::texturePathFor);
        ps.pushPose();
        float yawDeg = 0.0f;
        if (state.hasProperty((Property)H_FACING)) {
            yawDeg = ((Direction)state.getValue((Property)H_FACING)).toYRot();
        } else if (state.getProperties().stream().anyMatch(p -> Objects.equals(p.getName(), "facing"))) {
            try {
                DirectionProperty prop = state.getProperties().stream().filter(p -> Objects.equals(p.getName(), "facing")).findFirst().orElse(null);
                if (prop != null) {
                    yawDeg = ((Direction)state.getValue((Property)prop)).toYRot();
                }
            }
            catch (Exception prop) {
                // empty catch block
            }
        }
        ps.translate(0.5, 0.0, 0.5);
        ps.mulPose(Axis.YP.rotationDegrees(-yawDeg));
        ps.translate(-0.5, 0.0, -0.5);
        BBRenderer.Opts opts = BBRenderer.Opts.defaults().clip("idle").loop(false).center(true).autoLight(true).time(0.0f);
        BBRenderer.render(model, be, texture, ps, buffers, partialTicks, packedOverlay, opts);
        ps.popPose();
    }

    private String typeKey(Block block) {
        if (block == CFBlocks.STATUE_SQUIRTLE.get()) {
            return "squirtle";
        }
        if (block == CFBlocks.STATUE_BULBASAUR.get()) {
            return "bulbasaur";
        }
        if (block == CFBlocks.STATUE_CHARMANDER.get()) {
            return "charmander";
        }
        if (block == CFBlocks.STATUE_PIKACHU.get()) {
            return "pikachu";
        }
        return "ancient";
    }

    private ResourceLocation modelPathFor(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"cobblefurnies", (String)("models/bb/statue_" + key + ".bbs.json"));
    }

    private ResourceLocation texturePathFor(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"cobblefurnies", (String)("textures/block/statue/statue_" + key + ".png"));
    }
}

