/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.animation;

import com.lunazstudios.cobblefurnies.client.bbmodel.BBModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnimationMachine {
    private final Map<String, String> stateLoopClip = new HashMap<String, String>();
    private final List<Transition> transitions = new ArrayList<Transition>();
    private final BBModel model;
    private String currentState;
    private String activeClip;
    private boolean clipLoop;
    private long clipStartGT = 0L;
    private String targetState;
    private boolean dirtyTarget = false;

    public AnimationMachine(BBModel model) {
        this.model = model;
    }

    public AnimationMachine state(String state, String loopingClip) {
        this.stateLoopClip.put(state, loopingClip);
        return this;
    }

    public AnimationMachine transition(String from, String to, String onceClip) {
        this.transitions.add(new Transition(from, to, onceClip));
        return this;
    }

    public void initAtState(String state, long nowGT) {
        String clip;
        this.currentState = state;
        this.activeClip = clip = this.stateLoopClip.getOrDefault(state, state);
        this.clipLoop = true;
        this.clipStartGT = nowGT;
        this.targetState = state;
        this.dirtyTarget = false;
    }

    public void requestState(String state, long nowGT) {
        if (Objects.equals(this.targetState, state)) {
            return;
        }
        this.targetState = state;
        this.dirtyTarget = true;
        Transition t = this.findTransition(this.currentState, this.targetState);
        if (t != null) {
            this.activeClip = t.clipOnce;
            this.clipLoop = false;
            this.clipStartGT = nowGT;
        } else {
            this.goToLoopState(this.targetState, nowGT);
        }
    }

    private Transition findTransition(String from, String to) {
        for (Transition t : this.transitions) {
            if (!t.fromState.equals(from) || !t.toState.equals(to)) continue;
            return t;
        }
        return null;
    }

    private void goToLoopState(String state, long nowGT) {
        String clip;
        this.currentState = state;
        this.activeClip = clip = this.stateLoopClip.getOrDefault(state, state);
        this.clipLoop = true;
        this.clipStartGT = nowGT;
        this.dirtyTarget = false;
    }

    public Playback sample(long nowGT, float partialTicks) {
        float time;
        float duration = 0.0f;
        BBModel.AnimationClip def = this.model.clips.get(this.activeClip);
        if (def != null) {
            duration = def.durationSec;
        }
        float elapsed = ((float)(nowGT - this.clipStartGT) + partialTicks) / 20.0f;
        float f = duration > 0.0f ? (this.clipLoop ? elapsed % duration : Math.min(elapsed, duration)) : (time = elapsed);
        if (!this.clipLoop && duration > 0.0f && elapsed >= duration && this.dirtyTarget && this.targetState != null) {
            this.goToLoopState(this.targetState, nowGT);
            BBModel.AnimationClip finalDef = this.model.clips.get(this.activeClip);
            float finDur = finalDef != null ? finalDef.durationSec : 0.0f;
            float finElapsed = ((float)(nowGT - this.clipStartGT) + partialTicks) / 20.0f;
            float finTime = finDur > 0.0f ? finElapsed % finDur : finElapsed;
            return new Playback(this.activeClip, true, finTime);
        }
        return new Playback(this.activeClip, this.clipLoop, time);
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getActiveClip() {
        return this.activeClip;
    }

    public long getClipStartGT() {
        return this.clipStartGT;
    }

    public static final class Transition {
        public final String fromState;
        public final String toState;
        public final String clipOnce;

        public Transition(String fromState, String toState, String clipOnce) {
            this.fromState = fromState;
            this.toState = toState;
            this.clipOnce = clipOnce;
        }
    }

    public static final class Playback {
        public final String clip;
        public final boolean loop;
        public final float timeSec;

        public Playback(String clip, boolean loop, float timeSec) {
            this.clip = clip;
            this.loop = loop;
            this.timeSec = timeSec;
        }
    }
}

