/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block.entity;

import com.cobblemon.mod.common.CobblemonRecipeTypes;
import com.cobblemon.mod.common.item.components.PotComponent;
import com.cobblemon.mod.common.item.crafting.CookingPotRecipeBase;
import com.lunazstudios.cobblefurnies.block.StoveBlock;
import com.lunazstudios.cobblefurnies.menu.StoveMenu;
import com.lunazstudios.cobblefurnies.registry.CFBlockEntityTypes;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntity
extends BaseContainerBlockEntity
implements CraftingContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    public static final int RESULT_SLOT = 0;
    public static final int[] CRAFTING_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int[] SEASONING_SLOTS = new int[]{10, 11, 12};
    public static final int PREVIEW_SLOT = 13;
    public static final int TOTAL_SLOTS = 14;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)14, (Object)ItemStack.EMPTY);
    private PotComponent potComponent;
    private int cookingProgress = 0;
    private int cookingTotalTime = 200;
    private boolean isLidOpen = true;
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> StoveBlockEntity.this.cookingProgress;
                case 1 -> StoveBlockEntity.this.cookingTotalTime;
                case 2 -> {
                    if (StoveBlockEntity.this.level != null && ((Boolean)StoveBlockEntity.this.getBlockState().getValue((Property)StoveBlock.LID)).booleanValue()) {
                        yield 0;
                    }
                    yield 1;
                }
                case 3 -> 0;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    StoveBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 1: {
                    StoveBlockEntity.this.cookingTotalTime = value;
                    break;
                }
                case 2: {
                    StoveBlockEntity.this.toggleLid(value == 1);
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public void toggleLid(boolean isOpen) {
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        BlockState newState = (BlockState)state.setValue((Property)StoveBlock.LID, (Comparable)Boolean.valueOf(!isOpen));
        this.level.setBlock(this.worldPosition, newState, 3);
        this.setChanged();
    }

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        super(CFBlockEntityTypes.STOVE.get(), pos, state);
    }

    @NotNull
    public Component getDefaultName() {
        return Component.translatable((String)"container.cobblefurnies.stove");
    }

    @NotNull
    public Component getDisplayName() {
        return this.getDefaultName();
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> newItems) {
        this.items.clear();
        this.items.addAll(newItems);
    }

    public int getContainerSize() {
        return 14;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new StoveMenu(containerId, inventory, this, this.dataAccess);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void fillStackedContents(StackedContents stackedContents) {
        for (ItemStack itemStack : this.items) {
            stackedContents.accountSimpleStack(itemStack);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StoveBlockEntity stove) {
        if (level.isClientSide) {
            return;
        }
        CraftingInput input = CraftingInput.of((int)3, (int)3, (List)stove.items.subList(1, 10));
        Optional<RecipeHolder<CookingPotRecipeBase>> recipeOpt = StoveBlockEntity.fetchRecipe(level, input, (RecipeType<? extends CookingPotRecipeBase>)CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_COOKING());
        if (recipeOpt.isEmpty()) {
            recipeOpt = StoveBlockEntity.fetchRecipe(level, input, (RecipeType<? extends CookingPotRecipeBase>)CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_SHAPELESS());
        }
        if (recipeOpt.isEmpty()) {
            stove.cookingProgress = 0;
            stove.setItem(13, ItemStack.EMPTY);
            return;
        }
        RecipeHolder<CookingPotRecipeBase> recipeHolder = recipeOpt.get();
        CookingPotRecipeBase recipe = (CookingPotRecipeBase)recipeHolder.value();
        ItemStack result = recipe.assemble(input, (HolderLookup.Provider)level.registryAccess());
        List<ItemStack> validSeasonings = stove.getSeasonings().stream().filter(stack -> stack.is(recipe.getSeasoningTag())).toList();
        recipe.applySeasoning(result, validSeasonings);
        stove.setItem(13, result);
        ItemStack resultSlot = stove.getItem(0);
        boolean lidClosed = (Boolean)state.getValue((Property)StoveBlock.LID);
        if (!(lidClosed && (resultSlot.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)resultSlot, (ItemStack)result) && resultSlot.getCount() < resultSlot.getMaxStackSize()))) {
            stove.cookingProgress = 0;
            return;
        }
        stove.cookingProgress += 2;
        if (stove.cookingProgress >= stove.cookingTotalTime) {
            stove.cookingProgress = 0;
            stove.setRecipeUsed(recipeHolder);
            if (resultSlot.isEmpty()) {
                stove.setItem(0, result.copy());
            } else {
                resultSlot.grow(result.getCount());
            }
            stove.consumeIngredients(recipe);
            StoveBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void handleSafeDrop() {
        if (this.cookingProgress > 0) {
            ItemStack result = this.getItem(0);
            ItemStack preview = this.getItem(13);
            if (!preview.isEmpty() && (result.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)preview, (ItemStack)result))) {
                this.setItem(13, ItemStack.EMPTY);
            }
        }
    }

    private static Optional<RecipeHolder<CookingPotRecipeBase>> fetchRecipe(Level level, CraftingInput input, RecipeType<? extends CookingPotRecipeBase> type) {
        return level.getRecipeManager().getRecipeFor(type, (RecipeInput)input, level).map(r -> r);
    }

    private void consumeIngredients(CookingPotRecipeBase recipe) {
        for (int slot : CRAFTING_SLOTS) {
            this.consumeItem(slot);
        }
        for (int slot : SEASONING_SLOTS) {
            ItemStack seasoningStack = this.getItem(slot);
            if (seasoningStack.isEmpty() || !seasoningStack.is(recipe.getSeasoningTag()) || !recipe.getSeasoningProcessors().stream().anyMatch(p -> p.consumesItem(seasoningStack))) continue;
            this.consumeItem(slot);
        }
    }

    private void consumeItem(int slot) {
        ItemStack stack = this.getItem(slot);
        if (!stack.isEmpty()) {
            if (stack.getItem().hasCraftingRemainingItem()) {
                Item remainderItem = stack.getItem().getCraftingRemainingItem();
                stack.shrink(1);
                if (stack.isEmpty() && remainderItem != null) {
                    this.setItem(slot, new ItemStack((ItemLike)remainderItem));
                }
            } else {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    this.setItem(slot, ItemStack.EMPTY);
                }
            }
        }
    }

    public List<ItemStack> getSeasonings() {
        return this.items.subList(10, 13).stream().filter(stack -> !stack.isEmpty()).toList();
    }

    public void setPotItem(@Nullable ItemStack stack) {
        this.potComponent = stack != null && !stack.isEmpty() ? new PotComponent(stack) : null;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public ItemStack getPotItem() {
        return this.potComponent != null ? this.potComponent.getPotItem() : ItemStack.EMPTY;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("CookingProgress", this.cookingProgress);
        tag.putBoolean("IsLidOpen", this.isLidOpen);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (this.potComponent != null) {
            PotComponent.Companion.getCODEC().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.potComponent).result().ifPresent(potTag -> tag.put("PotComponent", potTag));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.cookingProgress = tag.getInt("CookingProgress");
        this.isLidOpen = tag.getBoolean("IsLidOpen");
        this.items.clear();
        for (int i = 0; i < 14; ++i) {
            this.items.add((Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (tag.contains("PotComponent")) {
            PotComponent.Companion.getCODEC().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("PotComponent")).result().ifPresent(component -> {
                this.potComponent = component;
            });
        }
    }
}

