/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block.entity;

import com.lunazstudios.cobblefurnies.menu.FurniCrafterMenu;
import com.lunazstudios.cobblefurnies.registry.CFBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FurniCrafterBlockEntity
extends BlockEntity
implements MenuProvider {
    private final SimpleContainer outputContainer = new SimpleContainer(1);

    public FurniCrafterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(CFBlockEntityTypes.FURNI_CRAFTER.get(), blockPos, blockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.cobblefurnies.furni_crafter");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new FurniCrafterMenu(id, inventory, this.level, this.worldPosition, this.getOutputContainer());
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.outputContainer.getItems(), (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.outputContainer.getItems(), (HolderLookup.Provider)registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public SimpleContainer getOutputContainer() {
        return this.outputContainer;
    }
}

