/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.FurnitureHorizontalBlock;
import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.block.properties.WallSupportShape;
import com.lunazstudios.cobblefurnies.registry.CFBlockTags;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallSupportBlock
extends FurnitureHorizontalBlock {
    protected static final VoxelShape SINGLE_SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)8.0, (double)14.0, (double)3.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)9.0, (double)13.0, (double)3.0, (double)12.0, (double)14.0), Block.box((double)1.0, (double)10.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0), Block.box((double)1.0, (double)11.0, (double)11.0, (double)3.0, (double)13.0, (double)12.0), Block.box((double)1.0, (double)12.0, (double)10.0, (double)3.0, (double)13.0, (double)11.0), Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)12.0, (double)7.0, (double)15.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)7.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0), Block.box((double)13.0, (double)12.0, (double)10.0, (double)15.0, (double)13.0, (double)11.0), Block.box((double)13.0, (double)11.0, (double)11.0, (double)15.0, (double)13.0, (double)12.0), Block.box((double)13.0, (double)10.0, (double)12.0, (double)15.0, (double)13.0, (double)13.0), Block.box((double)13.0, (double)9.0, (double)13.0, (double)15.0, (double)12.0, (double)14.0), Block.box((double)13.0, (double)8.0, (double)14.0, (double)15.0, (double)11.0, (double)15.0)});
    protected static final VoxelShape LEFT_SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)8.0, (double)14.0, (double)3.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)9.0, (double)13.0, (double)3.0, (double)12.0, (double)14.0), Block.box((double)1.0, (double)10.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0), Block.box((double)1.0, (double)11.0, (double)11.0, (double)3.0, (double)13.0, (double)12.0), Block.box((double)1.0, (double)12.0, (double)10.0, (double)3.0, (double)13.0, (double)11.0), Block.box((double)0.0, (double)7.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape RIGHT_SHAPE = Shapes.or((VoxelShape)Block.box((double)13.0, (double)8.0, (double)14.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)13.0, (double)9.0, (double)13.0, (double)15.0, (double)12.0, (double)14.0), Block.box((double)13.0, (double)10.0, (double)12.0, (double)15.0, (double)13.0, (double)13.0), Block.box((double)13.0, (double)11.0, (double)11.0, (double)15.0, (double)13.0, (double)12.0), Block.box((double)13.0, (double)12.0, (double)10.0, (double)15.0, (double)13.0, (double)11.0), Block.box((double)12.0, (double)7.0, (double)15.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape MIDDLE_SHAPE = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public WallSupportBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(CFBlockStateProperties.WALL_SUPPORT_SHAPE, (Comparable)((Object)WallSupportShape.SINGLE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CFBlockStateProperties.WALL_SUPPORT_SHAPE});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(CFBlockStateProperties.WALL_SUPPORT_SHAPE, (Comparable)((Object)this.getWallSupportShape((BlockGetter)level, pos, facing)));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState blockState2, LevelAccessor level, BlockPos pos, BlockPos blockPos2) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (direction.getAxis().isHorizontal()) {
            return (BlockState)state.setValue(CFBlockStateProperties.WALL_SUPPORT_SHAPE, (Comparable)((Object)this.getWallSupportShape((BlockGetter)level, pos, facing)));
        }
        return super.updateShape(state, direction, blockState2, level, pos, blockPos2);
    }

    private WallSupportShape getWallSupportShape(BlockGetter level, BlockPos pos, Direction facing) {
        Direction left = facing.getClockWise();
        Direction right = facing.getCounterClockWise();
        boolean hasLeft = this.validConnection(level.getBlockState(pos.relative(left)));
        boolean hasRight = this.validConnection(level.getBlockState(pos.relative(right)));
        if (hasLeft && hasRight) {
            return WallSupportShape.MIDDLE;
        }
        if (hasLeft) {
            return WallSupportShape.LEFT;
        }
        if (hasRight) {
            return WallSupportShape.RIGHT;
        }
        return WallSupportShape.SINGLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        WallSupportShape shape = (WallSupportShape)((Object)state.getValue(CFBlockStateProperties.WALL_SUPPORT_SHAPE));
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case WallSupportShape.SINGLE -> this.getRotatedShape(SINGLE_SHAPE, facing);
            case WallSupportShape.LEFT -> this.getRotatedShape(LEFT_SHAPE, facing);
            case WallSupportShape.RIGHT -> this.getRotatedShape(RIGHT_SHAPE, facing);
            case WallSupportShape.MIDDLE -> this.getRotatedShape(MIDDLE_SHAPE, facing);
        };
    }

    private VoxelShape getRotatedShape(VoxelShape shape, Direction facing) {
        return switch (facing) {
            case Direction.EAST -> ShapeUtil.rotateShape(shape, Direction.EAST);
            case Direction.SOUTH -> ShapeUtil.rotateShape(shape, Direction.SOUTH);
            case Direction.WEST -> ShapeUtil.rotateShape(shape, Direction.WEST);
            default -> shape;
        };
    }

    public boolean validConnection(BlockState state) {
        return state.is(CFBlockTags.WALL_SUPPORT_CONNECTABLE);
    }
}

